/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.function.Predicate;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.widgets.ModelToBean;

public class TimeEditorModel
extends AbstractSerializableBean
implements ModelToBean {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_TIME = "time";
    public static final String PROPERTY_TIME_IN_MINUTES = "timeInMinutes";
    public static final String PROPERTY_VALUE_IS_ADJUSTING = "valueIsAdjusting";
    protected Object bean;
    protected String propertyTime;
    protected Date time = new Date();
    protected final boolean fillState = true;
    protected boolean valueIsAdjusting;
    protected final Calendar calendar = new GregorianCalendar();

    public String getPropertyTime() {
        return this.propertyTime;
    }

    public void setPropertyTime(String propertyTime) {
        Preconditions.checkState((boolean)true, (Object)"cant change *propertyTimeDate* property once the fillState is off.");
        this.propertyTime = propertyTime;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        Preconditions.checkState((boolean)true, (Object)"cant change *bean* property once the fillState is off.");
        this.bean = bean;
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        boolean oldValue = this.isValueIsAdjusting();
        this.valueIsAdjusting = valueIsAdjusting;
        this.fireValueIsAdjusting(oldValue);
    }

    public void setHour(Integer hour) {
        if (!this.isValueIsAdjusting()) {
            Integer minute = this.time == null ? null : this.getMinute(this.time);
            this.setTime(hour, minute);
        }
    }

    public void setMinute(Integer minute) {
        if (!this.isValueIsAdjusting()) {
            Integer hour = this.time == null ? null : this.getHour(this.time);
            this.setTime(hour, minute);
        }
    }

    public Integer getTimeInMinutes() {
        int result = 0;
        if (this.time != null) {
            int hour = this.getHour(this.time);
            int minute = this.getMinute(this.time);
            result = hour * 60 + minute;
        }
        return result;
    }

    public void setTimeInMinutes(Integer time) {
        if (!this.isValueIsAdjusting()) {
            if (time == null) {
                this.setTime(null, null);
            } else {
                int hour = time / 60;
                int minute = time % 60;
                this.setTime(hour, minute);
            }
        }
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        Integer hour = null;
        Integer minute = null;
        if (time != null) {
            hour = this.getHour(time);
            minute = this.getMinute(time);
        }
        this.setTime(hour, minute);
    }

    protected Integer getHour(Date date) {
        Integer hour = null;
        if (date != null) {
            this.calendar.setTime(date);
            hour = this.calendar.get(11);
        }
        return hour;
    }

    protected Integer getMinute(Date date) {
        Integer hour = null;
        if (date != null) {
            this.calendar.setTime(date);
            hour = this.calendar.get(12);
        }
        return hour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTime(Integer hour, Integer minute) {
        Date oldTime = this.getTime();
        Integer oldTimeInMinutes = this.getTimeInMinutes();
        this.setValueIsAdjusting(true);
        try {
            if (hour == null || minute == null) {
                this.time = null;
            } else {
                this.calendar.setTime(new Date(0L));
                this.calendar.set(11, hour);
                this.calendar.set(12, minute);
                this.time = this.calendar.getTime();
            }
        }
        finally {
            this.setValueIsAdjusting(false);
            this.fireTime(oldTime);
            this.fireTimeInMinutes(oldTimeInMinutes);
        }
    }

    protected void fireTime(Date oldTime) {
        this.firePropertyChange(PROPERTY_TIME, oldTime, this.getTime());
    }

    protected void fireTimeInMinutes(Integer oldDate) {
        this.firePropertyChange(PROPERTY_TIME_IN_MINUTES, oldDate, this.getTimeInMinutes());
    }

    protected void fireValueIsAdjusting(boolean oldValue) {
        this.firePropertyChange(PROPERTY_VALUE_IS_ADJUSTING, oldValue, this.isValueIsAdjusting());
    }

    protected Predicate<TimeEditorModel> canUpdateBeanValuePredicate() {
        return input -> !this.isValueIsAdjusting();
    }
}

