package org.nuiton.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Widgets DateTime
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorUtil;
import org.nuiton.jaxx.validator.swing.meta.Validator;
import org.nuiton.jaxx.validator.swing.meta.ValidatorField;
import org.nuiton.jaxx.validator.swing.ui.ImageValidationUI;
import org.nuiton.jaxx.widgets.hidor.HidorButton;
import static io.ultreia.java4all.i18n.I18n.t;

public class TimeEditor extends JPanel implements BeanScopeAware, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_TIME_EDITOR_SLIDER = "showTimeEditorSlider";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HOUR_EDITOR_ENABLED = "hourEditor.enabled";
    public static final String BINDING_HOUR_MODEL_VALUE = "hourModel.value";
    public static final String BINDING_MINUTE_EDITOR_ENABLED = "minuteEditor.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_SLIDER_ENABLED = "slider.enabled";
    public static final String BINDING_SLIDER_HIDOR_TARGET_VISIBLE = "sliderHidor.targetVisible";
    public static final String BINDING_SLIDER_VALUE = "slider.value";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1WT08bRxQfO9iAgRbSKAeaqhZJE9OQtWmrSBX9BxhkIhMiTFBaDungHfDQ9exmZjZ2YiWHHnrrF+ih16pVle8Q9VSpl175DpXyEfre7Nq7hgXjcFi877157/d+8+Y3++d/JKMkWXDloSV8rl1hHdF225K+0LzJrHvLjx5t7R+xui4zVZfc064kwV8qTdJ7ZMLu2ZUm1l4VMhWDTEXMVAwzFVfdpucKJmKJlqokp/Qzh6kGY1qTwpmL60oVa73Ipbbny7BWIuqkWv/8tHicYuVf0oS0PYA/DW3fHiJB1PVIlaS5rcnl6hF9SosOFYcATnJxCA1NoW3VoUrdp032hLwko1WS9aiEZJrceSt6TDqTqu1pMnbj3gMqmFPSp/G3uH3ItLJsqplpZAceazYESM8zKbKaZJquzRxNSkOs3sQlUYrxhusHNk2uYcdtS7WAAKvmcSGYLEOGE0smmlz4oRVNM5Hrimq4rahWzeE2k5rMYGIL6bVWXNdhVMQAPKUQRSEahu5kHz1fFxQ+d7vGKEkOGw1qwm7G2wgYxrDxqCRSUqX72HN/sDFi1GwvuLtJi/h+rd+X071We9585EVqu6Cu9NUJycXAuV581sHqFXz7sN8zGTAeVbrZ77+sDNEVbrtyBwheoacqhuZ+hBOxdZrMnzVFDfRbJmrF1+DG5bcj3Crc5vf6ezTWkHlJbp51QkERrEgRosOZ2iMZ6YNZk+tnixHqyTZEBUpy/WwlwTIm8MdXL+VvrTfHXfmYBHD5QatiSgln2ZOuBw1zxPZuoB2+5k5xk3pLe2RcMQdk1sjorfOR18JIQA8ogmOCmawKVQ3Ilhk9fv3X1e//vUTS6yTnuNRepxi/ATPckMCY69ht7+tvDLjJ1hiqIcKEvWi4kj93habOssMPRdOoVrYO/5hsA1W3zqeqh+zV1pu/f/35o9ddulIA9MZFVkaUZb4jWS4cLpjR21BKE/V1wlPMt91IJ5OUk4Dyaa4d5oUK8Ll5fnmKh7QmU3XqMGFTuc6ZA1J/tbMaGqzK1sPtx1vrj8vL376AjKA1PszfQqdBhe0wacHsV7riuIvOgpFbtKPEFebnX7R9LLxsaMFfqySuqBeA11XwiU5vFWAZZYLuOwzgTnW4WgteCsnlYipzgXrnjoUmI5q14X0SN5OZnFYlqWgoVW/B/0zE/+bG/Yc7azHqrTj1m9ElMwT58btpCPqnOrF1Q25AnzgPqnkJMu67EoTxAeXAOVTIHFBHQfdZ16NPkIauYfwADrzG0l1bUvkE7R8EYgRAaCqByl2uuMk/C23WEu5u6BnYCG51+GL5oKMLc7HhQIcVAJgzkXBVsMRIdMQjswEAuF87gTV5O2PNDepqDMI9JNVc4gqHWSKdOWPc4fUfItv4ARyBO4o/h9/pxUVNppv0CPiDoJpH63B/gf1uKfaF1RGslS+zA+o7esX1hc3sbfieCSamUFrILy7k4Xm3lP84/8ln2OE0zMXJlJ+Wommf7fRN9IYIJl4FlA8xgOH9O4iflGm77qtBEzUM6SmjBc9c+Cwg73wBX2E0v8+FDd1+dSp1Cp+5gRnR/Ds+/kjO8D5k+B+NBShR7QwAAA==";
    private static final Logger log = LogManager.getLogger(TimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel dateEditor;
    protected TimeEditorHandler handler;
    protected JSpinner hourEditor;
    protected SpinnerDateModel hourModel;
    protected JLabel labelH;
    protected JSpinner minuteEditor;
    protected SpinnerDateModel minuteModel;
    protected TimeEditorModel model;
    protected Boolean showTimeEditorSlider;
    protected JSlider slider;
    protected HidorButton sliderHidor;
    protected JToolBar sliderHidorToolBar;
    @ValidatorField( validatorId = "validator",  propertyName = "time",  editorName = "timeEditor")
    protected JPanel timeEditor;
    protected JLabel timeLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<TimeEditorModel> validator;
    protected List<String> validatorIds;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TimeEditor $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    public void setPropertyTime(String property) { model.setPropertyTime(property); }
    public void setTime(Date time) { model.setTime(time); }
    
    public void setLabel(String label) { timeLabel.setText(label); }
    
    public void reset() {
       handler.reset();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor() {
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__$JPanel0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        hourEditor.requestFocusInWindow();
    }

    public void doStateChanged__on__hourEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setHours((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__minuteEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setMinutes((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__slider(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!slider.getValueIsAdjusting()) model.setTimeInMinutes((Integer)((JSlider)event.getSource()).getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getDateEditor() {
        return dateEditor;
    }

    public TimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHourEditor() {
        return hourEditor;
    }

    public SpinnerDateModel getHourModel() {
        return hourModel;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JSpinner getMinuteEditor() {
        return minuteEditor;
    }

    public SpinnerDateModel getMinuteModel() {
        return minuteModel;
    }

    public TimeEditorModel getModel() {
        return model;
    }

    public Boolean getShowTimeEditorSlider() {
        return showTimeEditorSlider;
    }

    public JSlider getSlider() {
        return slider;
    }

    public HidorButton getSliderHidor() {
        return sliderHidor;
    }

    public JToolBar getSliderHidorToolBar() {
        return sliderHidorToolBar;
    }

    public JPanel getTimeEditor() {
        return timeEditor;
    }

    public JLabel getTimeLabel() {
        return timeLabel;
    }

    public SwingValidator<TimeEditorModel> getValidator() {
        return validator;
    }

    public Boolean isShowTimeEditorSlider() {
        return showTimeEditorSlider !=null && showTimeEditorSlider;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowTimeEditorSlider(Boolean showTimeEditorSlider) {
        Boolean oldValue = this.showTimeEditorSlider;
        this.showTimeEditorSlider = showTimeEditorSlider;
        firePropertyChange(PROPERTY_SHOW_TIME_EDITOR_SLIDER, oldValue, showTimeEditorSlider);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDateEditor() {
        dateEditor.add(timeLabel, BorderLayout.WEST);
        dateEditor.add($JPanel1, BorderLayout.EAST);
    }

    protected void addChildrenToSliderHidorToolBar() {
        sliderHidorToolBar.add(sliderHidor);
    }

    protected void addChildrenToTimeEditor() {
        timeEditor.add(hourEditor);
        timeEditor.add(labelH);
        timeEditor.add(minuteEditor);
    }

    protected void addChildrenToValidator() {
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createDateEditor() {
        $objectMap.put("dateEditor", dateEditor = new JPanel());
        
        dateEditor.setName("dateEditor");
        dateEditor.setLayout(new BorderLayout());
    }

    protected void createHourEditor() {
        $objectMap.put("hourEditor", hourEditor = new JSpinner());
        
        hourEditor.setName("hourEditor");
        hourEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hourEditor"));
    }

    protected void createHourModel() {
        $objectMap.put("hourModel", hourModel = new SpinnerDateModel());
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setHorizontalAlignment(0);
        labelH.setText(t("timeeditor.H"));
    }

    protected void createMinuteEditor() {
        $objectMap.put("minuteEditor", minuteEditor = new JSpinner());
        
        minuteEditor.setName("minuteEditor");
        minuteEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minuteEditor"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerDateModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = new TimeEditorModel());
    }

    protected void createShowTimeEditorSlider() {
        $objectMap.put("showTimeEditorSlider", showTimeEditorSlider = true);
    }

    protected void createSlider() {
        $objectMap.put("slider", slider = new JSlider());
        
        slider.setName("slider");
        slider.setValue(0);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        if (slider.getFont() != null) {
            slider.setFont(slider.getFont().deriveFont((float) 11));
        }
        slider.setMajorTickSpacing(60);
        slider.setMinorTickSpacing(30);
        slider.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__slider"));
    }

    protected void createSliderHidor() {
        $objectMap.put("sliderHidor", sliderHidor = new HidorButton());
        
        sliderHidor.setName("sliderHidor");
        sliderHidor.setFocusable(false);
    }

    protected void createSliderHidorToolBar() {
        $objectMap.put("sliderHidorToolBar", sliderHidorToolBar = new JToolBar());
        
        sliderHidorToolBar.setName("sliderHidorToolBar");
        sliderHidorToolBar.setBorderPainted(false);
        sliderHidorToolBar.setOpaque(false);
        sliderHidorToolBar.setFloatable(false);
    }

    protected void createTimeEditor() {
        $objectMap.put("timeEditor", timeEditor = new JPanel());
        
        timeEditor.setName("timeEditor");
    }

    protected void createTimeLabel() {
        $objectMap.put("timeLabel", timeLabel = new JLabel());
        
        timeLabel.setName("timeLabel");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(TimeEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        handler = new TimeEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createHourModel();
        createMinuteModel();
        createShowTimeEditorSlider();
        createValidator();
        createDateEditor();
        createTimeLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createTimeEditor();
        createHourEditor();
        createLabelH();
        createMinuteEditor();
        createSliderHidorToolBar();
        createSliderHidor();
        createSlider();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JPanel0"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourModel.setValue(handler.getHourModelValue(model.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteModel.setValue(handler.getMinuteModelValue(model.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hourEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minuteEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_HIDOR_TARGET_VISIBLE, true ,"showTimeEditorSlider") {
        
            @Override
            public void processDataBinding() {
                sliderHidor.setTargetVisible(isShowTimeEditorSlider());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SLIDER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeInMinutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    slider.setValue(model.getTimeInMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeInMinutes", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                slider.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(dateEditor, BorderLayout.NORTH);
        add(slider, BorderLayout.SOUTH);
        addChildrenToValidator();
        addChildrenToDateEditor();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(timeEditor));
        $JPanel1.add(sliderHidorToolBar);
        addChildrenToTimeEditor();
        addChildrenToSliderHidorToolBar();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 10 property setters
        hourModel.setCalendarField(Calendar.HOUR_OF_DAY);
        minuteModel.setCalendarField(Calendar.MINUTE);
        hourEditor.setModel(hourModel);
        minuteEditor.setModel(minuteModel);
        sliderHidor.setShowTip(t("timeeditor.show.slider"));
        sliderHidor.setHideTip(t("timeeditor.hide.slider"));
        sliderHidor.setTarget(slider);
        slider.setModel(new DefaultBoundedRangeModel(0, 1, 0, 60 * 24));// late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
