package org.nuiton.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Widgets DateTime
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class JAXXDatePicker extends JXDatePicker implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PATTERN_LAYOUT = "patternLayout";
    public static final String PROPERTY_SHOW_POPUP_BUTTON = "showPopupButton";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Tu24TQRS9NrFDHPIAJOpICQQJ2A0tRjwcE+FoIRFRJAs3TLwje8x6Zpi5izdNCgo6foCClgblHyIqJBpa/wNSPoG7D7wWshNgi1lpdO6Zc+8958tPKFkDt5XpODIUqKTTY1HkmFCi6HNn+3GzuXPQ422sc9s2QqMykH6FIhRbMO+P7i2C0/KIyU2Z3JjJzZjcTdXXSnI5RlT1oGLxMOC2yzki3Jxa3LbW3Rshq5EOTfbWRNWT3vr+/u6wwOsfiwCRJvkz1PatfyDIu57xoCh8hCtej71lbsBkh8QZITvU0EJ8txkwa5+zPn8DRzDrQVkzQ2QId/5rPAldQhVphMW17WadId8V7dfcbCC4f3YxEH6Ho3V8Qo22mJdonZCVEZZsVw12lQ51LUQqR7gcy3filpyaUgFnMkcvaIbIjfTYoSI4LOfYtP0cWuERculzf7+BcO9cfU8ydI1Z0c6F7jeI0cCNaVsiVzi5K/IFFVpQMiFdI6xON2TsqReESt20Ot1N8TMJ8N3xkfk8OB3+tlCBxK2cVzWWFtqnNkpzgyLWtpT6J0QRuM+YrrZgzvKAopZEaf1s5XsZktSTinRtMZPzlNkusZVmhydfr736cQGKW1AJFPO3WIxvwBx2DU1MBX6kHz5KxF0aXKRzOZY5yRSL92lTbOVASJ+2/CCica2fPa6RuuOd02+fPlw/GR/Z2t9U5mMrvYSykIGQPMldFqmJOZvXloe+yvMyKUGF+H9Va/0Lh929rPwEAAA=";
    private static final Logger log = LogManager.getLogger(JAXXDatePicker.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ExtendedBasicDatePickerUI extendedUI;
    protected String patternLayout;
    protected Boolean showPopupButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JAXXDatePicker $JXDatePicker0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
            setUI(extendedUI);
    
            addPropertyChangeListener(PROPERTY_SHOW_POPUP_BUTTON, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    extendedUI.setShowPopupButton((Boolean) evt.getNewValue());
                }
            });
    
            addPropertyChangeListener(PROPERTY_PATTERN_LAYOUT, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    setFormats(new SimpleDateFormat((String) evt.getNewValue()));
                }
            });
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXDatePicker(Date param0) {
        super(param0);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Date param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker(Locale param0) {
        super(param0);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Locale param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker(Date param0, Locale param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Date param1, Locale param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker() {
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ExtendedBasicDatePickerUI getExtendedUI() {
        return extendedUI;
    }

    public String getPatternLayout() {
        return patternLayout;
    }

    public Boolean getShowPopupButton() {
        return showPopupButton;
    }

    public Boolean isShowPopupButton() {
        return showPopupButton !=null && showPopupButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setPatternLayout(String patternLayout) {
        String oldValue = this.patternLayout;
        this.patternLayout = patternLayout;
        firePropertyChange(PROPERTY_PATTERN_LAYOUT, oldValue, patternLayout);
    }

    public void setShowPopupButton(Boolean showPopupButton) {
        Boolean oldValue = this.showPopupButton;
        this.showPopupButton = showPopupButton;
        firePropertyChange(PROPERTY_SHOW_POPUP_BUTTON, oldValue, showPopupButton);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createExtendedUI() {
        $objectMap.put("extendedUI", extendedUI = new ExtendedBasicDatePickerUI());
    }

    protected void createPatternLayout() {
        $objectMap.put("patternLayout", patternLayout = "dd/MM/yyyy");
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = Boolean.TRUE);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JXDatePicker0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JXDatePicker0", $JXDatePicker0);
        createShowPopupButton();
        createPatternLayout();
        createExtendedUI();
        // inline creation of $JXDatePicker0
        setName("$JXDatePicker0");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 1 property setters
        extendedUI.setShowPopupButton(showPopupButton);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
