/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import io.ultreia.java4all.lang.Setters;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.ModelToBean;
import org.nuiton.jaxx.widgets.MutateOnConditionalPropertyChangeListener;
import org.nuiton.jaxx.widgets.datetime.TimeEditor;
import org.nuiton.jaxx.widgets.datetime.TimeEditorModel;
import org.nuiton.jaxx.widgets.datetime.TimeSliderInitializer;

public class TimeEditorHandler
implements UIHandler<TimeEditor> {
    private static final Logger log = LogManager.getLogger(TimeEditorHandler.class);
    protected TimeEditor ui;
    protected final Calendar calendarMinute = new GregorianCalendar();
    protected final Calendar calendarHour = new GregorianCalendar();

    public void beforeInit(TimeEditor ui) {
        TimeEditorModel model = new TimeEditorModel();
        ui.setContextValue(model);
        this.ui = ui;
    }

    public void afterInit(TimeEditor ui) {
        ui.getMinuteEditor().setEditor(new JSpinner.DateEditor(ui.getMinuteEditor(), "mm"));
        ui.getHourEditor().setEditor(new JSpinner.DateEditor(ui.getHourEditor(), "HH"));
        JSlider slider = ui.getSlider();
        TimeSliderInitializer timeSliderInitializer = new TimeSliderInitializer();
        timeSliderInitializer.init(slider);
    }

    public void init(TimeEditor ui) {
        TimeEditorModel model = ui.getModel();
        Object bean = model.getBean();
        if (bean != null) {
            Predicate<TimeEditorModel> predicate = model.canUpdateBeanValuePredicate();
            if (model.getPropertyTime() != null) {
                Method mutator = Setters.getMutator((Object)bean, (String)model.getPropertyTime());
                Objects.requireNonNull(mutator, "could not find mutator for " + model.getPropertyTime());
                model.addPropertyChangeListener("time", (PropertyChangeListener)new MutateOnConditionalPropertyChangeListener((ModelToBean)model, mutator, predicate));
            }
        }
    }

    public Date getMinuteModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
        }
        this.calendarMinute.setTime(incomingDate);
        this.calendarMinute.set(11, 0);
        incomingDate = this.calendarMinute.getTime();
        return incomingDate;
    }

    public Date getHourModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
        }
        this.calendarHour.setTime(incomingDate);
        this.calendarHour.set(12, 0);
        incomingDate = this.calendarHour.getTime();
        return incomingDate;
    }

    public void setHours(Date hourDate) {
        TimeEditorModel model = this.ui.getModel();
        Date oldTime = model.getTime();
        if (oldTime == null) {
            return;
        }
        this.calendarHour.setTime(hourDate);
        int newHour = this.calendarHour.get(11);
        int newMinute = this.calendarHour.get(12);
        int oldHour = model.getHour(oldTime);
        int oldMinute = model.getMinute(oldTime);
        if (oldHour == newHour && oldMinute == newMinute) {
            if (log.isDebugEnabled()) {
                log.debug("Do not update time model , stay on same time = " + oldHour + ":" + oldMinute);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("hh:mm (old from dateModel)   = " + oldHour + ":" + oldMinute);
            log.debug("hh:mm (new from hourModel) = " + newHour + ":" + newMinute);
        }
        model.setTimeInMinutes(newHour * 60 + oldMinute);
    }

    public void setMinutes(Date minuteDate) {
        TimeEditorModel model = this.ui.getModel();
        Date oldTime = model.getTime();
        if (oldTime == null) {
            return;
        }
        this.calendarMinute.setTime(minuteDate);
        int newHour = this.calendarMinute.get(11);
        int newMinute = this.calendarMinute.get(12);
        int oldHour = model.getHour(oldTime);
        int oldMinute = model.getMinute(oldTime);
        if (oldHour == newHour && oldMinute == newMinute) {
            if (log.isDebugEnabled()) {
                log.debug("Do not update time model , stay on same time = " + oldHour + ":" + oldMinute);
            }
            return;
        }
        int hour = oldHour;
        if (log.isDebugEnabled()) {
            log.debug("hh:mm (old from dateModel)   = " + oldHour + ":" + oldMinute);
            log.debug("hh:mm (new from minuteModel) = " + newHour + ":" + newMinute);
        }
        if (newMinute == 0) {
            if (newHour == 1) {
                hour = (oldHour + 1) % 24;
            }
        } else if (newMinute == 59 && newHour == 23) {
            hour = (oldHour - 1) % 24;
        }
        if (log.isDebugEnabled()) {
            log.debug("Update time model to hh:mm = " + hour + ":" + newMinute);
        }
        model.setTimeInMinutes(hour * 60 + newMinute);
    }
}

