package org.nuiton.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Widgets DateTime
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.ApplicationAction;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorUtil;
import org.nuiton.jaxx.validator.swing.meta.Validator;
import org.nuiton.jaxx.validator.swing.meta.ValidatorField;
import org.nuiton.jaxx.validator.swing.ui.ImageValidationUI;
import org.nuiton.jaxx.widgets.hidor.HidorButton;
import static io.ultreia.java4all.i18n.I18n.t;

public class DateTimeEditor extends JPanel implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_TIME_EDITOR_SLIDER = "showTimeEditorSlider";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DAY_DATE_EDITOR_DATE = "dayDateEditor.date";
    public static final String BINDING_DAY_DATE_EDITOR_ENABLED = "dayDateEditor.enabled";
    public static final String BINDING_HOUR_EDITOR_ENABLED = "hourEditor.enabled";
    public static final String BINDING_HOUR_MODEL_VALUE = "hourModel.value";
    public static final String BINDING_MINUTE_EDITOR_ENABLED = "minuteEditor.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_SLIDER_ENABLED = "slider.enabled";
    public static final String BINDING_SLIDER_HIDOR_TARGET_VISIBLE = "sliderHidor.targetVisible";
    public static final String BINDING_SLIDER_VALUE = "slider.value";
    public static final String BINDING_TOOLBAR_RESET_VISIBLE = "toolbarReset.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XT08bRxQfHMwf8zdpyiFKWxcomJSsDYmiSlRtAIMA2YDAQbQc0sE74CHr3c3sLJhYyaGH3voFeui1lyrfIeqpUi/pke9QKR+h783uetdmAZOEw2j9/vzm9968eW/48z+SdASZtsShZrpcWqZ2RGs1Tbim5FWmrc3v7m7sH7GyzDOnLLgtLUG8v44ESeyRPr0hdyTR9gqAlPWQsoiU9ZGyi1bVtkxmRoDmCiTlyFODORXGpCSZC53LjpPdbljO1WxX+HvFso7b659fZs46WP63BCE1G+h/CmF/fQ2AMOrOAklwXZJbhSN6TLMGNQ+BnODmIQQ0gLJFgzrOOq2y5+QV6S6QLpsKAJPk/nulR8EpqJotSc/42iY1mZGTJNvK/4Trh0w6mk4lU4Hk4aMEH0s6GAnbVjBdkiSrls4MSR5eE6GIbiFMb8VyPZkkdzHymuacQCK0bZubJhPo3OLSV+Wm60tRdDNU3XYq1km417bBdSYkuYnAGqZZW7Asg1EzQgBdtpjDJApGIopjCu4UYKAqW4Ns6AK2uO4EwhAkhVnwyMBxR+PzjgDNehvWwcHM4O/Pcbnb0A3ofhoLdB+T1QymhGj5RcOhX0Ko+1So2CA1TfYl0C1Q0ezRJ9B0wZUQpiSfNDl4UjQcP0d3Np7uaT4SexozeARX/Zm0bA+0pq3toskmLz9jisq9hvsgVk7o39ggtEhh4QTozcH5pYOG2YZ9l4EpWsFfY82afq+ewp0eNOtvOaqMVrhuiUjeJpr59EWsJJm66FZUUK8pqzCl34QsHb9km7PvFbJfLIJMXNR1oMtpYZcLG07HHkkKF8SSjF3cYLFHboGV1x3HLu6OuI0y/Pn1K/HHybuzoCUOAbn0VV6R7g/9yRaWDQFz5Dbk9UNXciNbpPbcHtxOZsDoUKNh8nLm274lsAcW3pVHJG2FOhVAS3afvflr5Ke3N0himaQMi+rLFO1XSa+sQOVXLEOv2d8/VuT6T3pgHUaacBYVS/AXcCeoMW/wQ7OqOvFQ3bt12uLSemlp62UNcjZ5ec4aFF9vvPv791+/ehPkrQMYj7fjGeYu+SPp4qbBTaaGiT8nYodHn+0wV7fCIRA3Fgi0dMmlwWy/ey2pdfVcQm5I0ql6O7ldVzNAg8LOe7c9M/VSku4DS1SphBMbrI/qerZYzJ7C3yiqmEn3DQajb7LOnSXvR2YqPTGR9qC4E1x6VAFczUUWRZUj/Nogrb3lKr4JcChTg5k6FcucGbD5SH3RF2grG0+2nm4sP83P/wD8ktDXXYgsV69QUzeYwNhWggm1g8pMI+aS36IyU/E0w9HWBsVgnPbVG17t5SuYdpfkK9Iq22DSXrVDEUhWA8VwMOeZ2kBbiWPgN9/3OKqb4VEVV9eflJYipzQbPaVi+Ci45jlF3xPXOKmBesTvo51V0zBq4yoO7FsCRsMm5abEvZMH1IAhTrosmz7HJAWC3gNoeWrnQBa3fcysu4pEJ5CQVECid7jDFf4dSMB2zEvMaw/eGw3eoV/WZWa0pXxQqXkkRpU1DEx2oTUqo9ZdHhF4mtQ9afyBR4K8KroeMLcxuar6HSx7gWlNKWEJni6hrPcAbs19h7+A78TMDNyNKj2CPILRtk3LMMlB/igXllCubrKTdJ4dUNeQC5Zr6kzfgleqV1OZ3HR6ZjoN66Nc+l569iFGOAz10Qr5IBfeiTv1prpfNb174Xip/ygl6r9RPqA4u4+DShnyK0U9UhXH9uq06XHbRoWmYNRzyyyd2gD7+Jr/sqhN5hWAVsaRqY667DpRltHsDkSzCzH1K+uWNMRWZuQFflVUHaqtnlpgTAa/Beo0vc9NHUriu3PQHbimrkRE8Vtc/o1H+OyDEdKA8D+py446MhAAAA==";
    private static final Logger log = LogManager.getLogger(DateTimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "date",  editorName = "dateEditor")
    protected JPanel dateEditor;
    protected JLabel dateTimeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "dayDate",  editorName = "dayDateEditor")
    protected JXDatePicker dayDateEditor;
    protected DateTimeEditorHandler handler;
    protected JSpinner hourEditor;
    protected SpinnerDateModel hourModel;
    protected JLabel labelH;
    protected JSpinner minuteEditor;
    protected SpinnerDateModel minuteModel;
    protected DateTimeEditorModel model;
    protected JButton resetButton;
    protected Boolean showReset;
    protected Boolean showTimeEditorSlider;
    protected JSlider slider;
    protected HidorButton sliderHidor;
    protected JToolBar sliderHidorToolBar;
    @ValidatorField( validatorId = "validator",  propertyName = "timeDate",  editorName = "timeDateEditor")
    protected JPanel timeDateEditor;
    protected JToolBar toolbarReset;
    @Validator( validatorId = "validator")
    protected SwingValidator<DateTimeEditorModel> validator;
    protected List<String> validatorIds;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditor $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    public void setPropertyTimeDate(String property) { model.setPropertyTimeDate(property); }
    public void setPropertyDayDate(String property) { model.setPropertyDayDate(property); }
    public void setPropertyDate(String property) { model.setPropertyDate(property); }
    public void setDateEditable(boolean dateEditable) { model.setDateEditable(dateEditable); }
    public void setTimeEditable(boolean timeEditable) { model.setTimeEditable(timeEditable); }
    public void setBean(Object bean) { model.setBean(bean); }
    public void setDate(Date date) { model.setDate(date); }
    
    public void setDateFormat(String dateFormat) { dayDateEditor.setFormats(dateFormat); }
    public void setLabel(String label) { dateTimeLabel.setText(label); }
    public void reset() { model.reset(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor() {
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__dayDateEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setDayDate((Date)((JXDatePicker)event.getSource()).getDate());
    }

    public void doStateChanged__on__hourEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setHours((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__minuteEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setMinutes((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__slider(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!slider.getValueIsAdjusting()) model.setTimeInMinutes((Integer)((JSlider)event.getSource()).getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getDateEditor() {
        return dateEditor;
    }

    public JLabel getDateTimeLabel() {
        return dateTimeLabel;
    }

    public JXDatePicker getDayDateEditor() {
        return dayDateEditor;
    }

    public DateTimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHourEditor() {
        return hourEditor;
    }

    public SpinnerDateModel getHourModel() {
        return hourModel;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JSpinner getMinuteEditor() {
        return minuteEditor;
    }

    public SpinnerDateModel getMinuteModel() {
        return minuteModel;
    }

    public DateTimeEditorModel getModel() {
        return model;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public Boolean getShowTimeEditorSlider() {
        return showTimeEditorSlider;
    }

    public JSlider getSlider() {
        return slider;
    }

    public HidorButton getSliderHidor() {
        return sliderHidor;
    }

    public JToolBar getSliderHidorToolBar() {
        return sliderHidorToolBar;
    }

    public JPanel getTimeDateEditor() {
        return timeDateEditor;
    }

    public JToolBar getToolbarReset() {
        return toolbarReset;
    }

    public SwingValidator<DateTimeEditorModel> getValidator() {
        return validator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public Boolean isShowTimeEditorSlider() {
        return showTimeEditorSlider !=null && showTimeEditorSlider;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowTimeEditorSlider(Boolean showTimeEditorSlider) {
        Boolean oldValue = this.showTimeEditorSlider;
        this.showTimeEditorSlider = showTimeEditorSlider;
        firePropertyChange(PROPERTY_SHOW_TIME_EDITOR_SLIDER, oldValue, showTimeEditorSlider);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDateEditor() {
        dateEditor.add($JPanel1, BorderLayout.WEST);
        dateEditor.add($JPanel2, BorderLayout.EAST);
    }

    protected void addChildrenToSliderHidorToolBar() {
        sliderHidorToolBar.add(sliderHidor);
    }

    protected void addChildrenToTimeDateEditor() {
        timeDateEditor.add(hourEditor);
        timeDateEditor.add(labelH);
        timeDateEditor.add(minuteEditor);
    }

    protected void addChildrenToToolbarReset() {
        toolbarReset.add(resetButton);
    }

    protected void addChildrenToValidator() {
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createDateEditor() {
        $objectMap.put("dateEditor", dateEditor = new JPanel());
        
        dateEditor.setName("dateEditor");
        dateEditor.setLayout(new BorderLayout());
    }

    protected void createDateTimeLabel() {
        $objectMap.put("dateTimeLabel", dateTimeLabel = new JLabel());
        
        dateTimeLabel.setName("dateTimeLabel");
    }

    protected void createDayDateEditor() {
        $objectMap.put("dayDateEditor", dayDateEditor = new JXDatePicker());
        
        dayDateEditor.setName("dayDateEditor");
        dayDateEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dayDateEditor"));
    }

    protected void createHourEditor() {
        $objectMap.put("hourEditor", hourEditor = new JSpinner());
        
        hourEditor.setName("hourEditor");
        hourEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hourEditor"));
    }

    protected void createHourModel() {
        $objectMap.put("hourModel", hourModel = new SpinnerDateModel());
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setText(t("datetimeeditor.H"));
    }

    protected void createMinuteEditor() {
        $objectMap.put("minuteEditor", minuteEditor = new JSpinner());
        
        minuteEditor.setName("minuteEditor");
        minuteEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minuteEditor"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerDateModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = new DateTimeEditorModel());
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setFocusPainted(false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createShowTimeEditorSlider() {
        $objectMap.put("showTimeEditorSlider", showTimeEditorSlider = true);
    }

    protected void createSlider() {
        $objectMap.put("slider", slider = new JSlider());
        
        slider.setName("slider");
        slider.setValue(0);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        if (slider.getFont() != null) {
            slider.setFont(slider.getFont().deriveFont((float) 11));
        }
        slider.setMajorTickSpacing(60);
        slider.setMinorTickSpacing(30);
        slider.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__slider"));
    }

    protected void createSliderHidor() {
        $objectMap.put("sliderHidor", sliderHidor = new HidorButton());
        
        sliderHidor.setName("sliderHidor");
    }

    protected void createSliderHidorToolBar() {
        $objectMap.put("sliderHidorToolBar", sliderHidorToolBar = new JToolBar());
        
        sliderHidorToolBar.setName("sliderHidorToolBar");
        sliderHidorToolBar.setBorderPainted(false);
        sliderHidorToolBar.setOpaque(false);
        sliderHidorToolBar.setFloatable(false);
    }

    protected void createTimeDateEditor() {
        $objectMap.put("timeDateEditor", timeDateEditor = new JPanel());
        
        timeDateEditor.setName("timeDateEditor");
    }

    protected void createToolbarReset() {
        $objectMap.put("toolbarReset", toolbarReset = new JToolBar());
        
        toolbarReset.setName("toolbarReset");
        toolbarReset.setBorderPainted(false);
        toolbarReset.setFloatable(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(DateTimeEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        handler = new DateTimeEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createHourModel();
        createMinuteModel();
        createShowTimeEditorSlider();
        createShowReset();
        createValidator();
        createDateEditor();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDateTimeLabel();
        createToolbarReset();
        createResetButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        createDayDateEditor();
        createTimeDateEditor();
        createHourEditor();
        createLabelH();
        createMinuteEditor();
        createSliderHidorToolBar();
        createSliderHidor();
        createSlider();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 11 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourModel.setValue(handler.getHourModelValue(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteModel.setValue(handler.getMinuteModelValue(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_RESET_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarReset.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DAY_DATE_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dayDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dayDateEditor.setDate(model.getDayDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dayDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DAY_DATE_EDITOR_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("dateEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dayDateEditor.setEnabled(isEnabled() && model.isDateEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("dateEditable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_EDITOR_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("timeEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourEditor.setEnabled(isEnabled() && model.isTimeEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("timeEditable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_EDITOR_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("timeEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteEditor.setEnabled(isEnabled() && model.isTimeEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("timeEditable", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_HIDOR_TARGET_VISIBLE, true ,"showTimeEditorSlider") {
        
            @Override
            public void processDataBinding() {
                sliderHidor.setTargetVisible(isShowTimeEditorSlider());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SLIDER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeInMinutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    slider.setValue(model.getTimeInMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeInMinutes", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SLIDER_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("timeEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    slider.setEnabled(isEnabled() && model.isTimeEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("timeEditable", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(SwingUtil.boxComponentWithJxLayer(dateEditor), BorderLayout.NORTH);
        add(slider, BorderLayout.SOUTH);
        addChildrenToValidator();
        addChildrenToDateEditor();
        // inline complete setup of $JPanel1
        $JPanel1.add(dateTimeLabel, BorderLayout.WEST);
        $JPanel1.add(toolbarReset, BorderLayout.EAST);
        addChildrenToToolbarReset();
        // inline complete setup of $JPanel2
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(dayDateEditor));
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(timeDateEditor));
        $JPanel2.add(sliderHidorToolBar);
        addChildrenToTimeDateEditor();
        addChildrenToSliderHidorToolBar();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 13 property setters
        hourModel.setCalendarField(Calendar.HOUR_OF_DAY);
        minuteModel.setCalendarField(Calendar.MINUTE);
        dayDateEditor.setFormats("dd/MM/yyyy");
        hourEditor.setModel(hourModel);
        labelH.setHorizontalAlignment(JLabel.CENTER);
        minuteEditor.setModel(minuteModel);
        sliderHidor.setShowTip(t("datetimeeditor.show.slider"));
        sliderHidor.setHideTip(t("datetimeeditor.hide.slider"));
        sliderHidor.setTarget(slider);
        slider.setModel(new DefaultBoundedRangeModel(0, 1, 0, 60 * 24));// late initializer
        
        ApplicationAction.init(this, resetButton, org.nuiton.jaxx.widgets.datetime.DateTimeEditorResetAction.class);// register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
