/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.config.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import io.ultreia.java4all.config.ApplicationConfig;
import io.ultreia.java4all.config.ConfigOptionDef;
import java.io.File;
import javax.swing.Icon;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.config.model.CallBackFinalizer;
import org.nuiton.jaxx.widgets.config.model.CategoryModel;
import org.nuiton.jaxx.widgets.config.model.ConfigUIModel;
import org.nuiton.jaxx.widgets.config.model.OptionModel;

public class ConfigUIModelBuilder {
    private static final Log log = LogFactory.getLog(ConfigUIModelBuilder.class);
    ConfigUIModel model;
    CategoryModel category;
    String categoryDefaultCallBack;
    OptionModel option;

    public ConfigUIModelBuilder createModel(Object configurationBean, ApplicationConfig config, File configFile) throws IllegalStateException, NullPointerException {
        this.checkNoCurrent(this.model, "model");
        this.checkNotNull(config, "createModel", "config");
        this.checkNotNull(configFile, "createModel", "configFile");
        this.model = new ConfigUIModel(configurationBean, config, configFile);
        if (log.isDebugEnabled()) {
            log.debug((Object)("model created : " + this.model));
        }
        return this;
    }

    @Deprecated
    public ConfigUIModelBuilder createModel(Supplier<ApplicationConfig> config) throws IllegalStateException, NullPointerException {
        return this.createModel(config, (ApplicationConfig)config.get(), ((ApplicationConfig)config.get()).getUserConfigFile());
    }

    @Deprecated
    public ConfigUIModelBuilder createModel(Supplier<ApplicationConfig> config, File configFile) throws IllegalStateException, NullPointerException {
        return this.createModel(config, (ApplicationConfig)config.get(), configFile);
    }

    @Deprecated
    public ConfigUIModelBuilder createModel(Object configurationBean, ApplicationConfig config) throws IllegalStateException, NullPointerException {
        return this.createModel(configurationBean, config, config.getUserConfigFile());
    }

    @Deprecated
    public ConfigUIModelBuilder createModel(ApplicationConfig config) throws IllegalStateException, NullPointerException {
        return this.createModel(config, config, config.getUserConfigFile());
    }

    @Deprecated
    public ConfigUIModelBuilder createModel(ApplicationConfig config, File configFile) throws IllegalStateException, NullPointerException {
        return this.createModel(config, config, configFile);
    }

    public ConfigUIModelBuilder addCategory(String categoryName, String categoryLabel) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.model, "model");
        this.checkNotNull(categoryName, "addCategory", "categoryName");
        this.checkNotNull(categoryLabel, "addCategory", "categoryLabel");
        this.flushCategory();
        this.category = new CategoryModel(categoryName, categoryLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("category created : " + this.category));
        }
        return this;
    }

    public ConfigUIModelBuilder addCategory(String categoryName, String categoryLabel, String defaultCallback) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.model, "model");
        this.checkNotNull(categoryName, "addCategory", "categoryName");
        this.checkNotNull(categoryLabel, "addCategory", "categoryLabel");
        this.flushCategory();
        this.categoryDefaultCallBack = defaultCallback;
        this.category = new CategoryModel(categoryName, categoryLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("category created : " + this.category));
        }
        return this;
    }

    public ConfigUIModelBuilder addOption(ConfigOptionDef def) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.model, "model");
        this.checkCurrent(this.category, "category");
        this.checkNotNull(def, "addOption", "def");
        this.flushOption();
        Object value = this.model.getApplicationConfig().getOption(def);
        this.option = new OptionModel(def, value);
        if (this.categoryDefaultCallBack != null) {
            this.model.registerOptionCallBack(this.categoryDefaultCallBack, this.option);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("option created : " + this.option));
        }
        return this;
    }

    @Deprecated
    public ConfigUIModelBuilder addOption(ConfigOptionDef def, String propertyName) throws IllegalStateException, NullPointerException {
        this.addOption(def);
        this.checkNotNull(propertyName, "setOptionPropertyName", "propertyName");
        this.option.setPropertyName(propertyName);
        return this;
    }

    public ConfigUIModelBuilder setOptionPropertyName(String propertyName) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.option, "option");
        this.checkNotNull(propertyName, "setOptionPropertyName", "propertyName");
        this.option.setPropertyName(propertyName);
        return this;
    }

    public ConfigUIModelBuilder setOptionShortLabel(String shortLabel) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.option, "option");
        this.checkNotNull(shortLabel, "setShortLabel", "shortLabel");
        this.option.setShortLabel(shortLabel);
        return this;
    }

    public ConfigUIModelBuilder setOptionEditor(TableCellEditor editor) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.option, "option");
        this.checkNotNull(editor, "setOptionEditor", "editor");
        this.option.setEditor(editor);
        return this;
    }

    public ConfigUIModelBuilder setOptionRenderer(TableCellRenderer renderer) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.option, "option");
        this.checkNotNull(renderer, "setOptionRenderer", "renderer");
        this.option.setRenderer(renderer);
        return this;
    }

    public ConfigUIModelBuilder registerCallBack(String name, String description, Icon icon, Runnable action) {
        this.checkCurrent(this.model, "model");
        this.checkNotNull(name, "registerCallBack", "name");
        this.checkNotNull(description, "registerCallBack", "description");
        this.checkNotNull(action, "registerCallBack", "action");
        this.model.registerCallBack(name, description, icon, action);
        return this;
    }

    public ConfigUIModelBuilder setOptionCallBack(String name) {
        this.checkCurrent(this.option, "option");
        this.checkNotNull(name, "setOptionCallBack", "name");
        Preconditions.checkArgument((this.categoryDefaultCallBack == null ? 1 : 0) != 0, (Object)"You can not use the method *setOptionCallBack* when a default callback has been assigned to a category");
        this.model.registerOptionCallBack(name, this.option);
        return this;
    }

    public ConfigUIModelBuilder setFinalizer(CallBackFinalizer finalizer) {
        this.model.setFinalizer(finalizer);
        return this;
    }

    public ConfigUIModelBuilder setCategoryDefaultCallBack(String categoryDefaultCallBack) {
        this.checkCurrent(this.model, "model");
        this.checkCurrent(this.category, "category");
        this.categoryDefaultCallBack = categoryDefaultCallBack;
        return this;
    }

    public ConfigUIModel flushModel() throws IllegalStateException {
        this.checkCurrent(this.model, "model");
        this.flushCategory();
        ConfigUIModel result = this.model;
        this.model = null;
        return result;
    }

    public ConfigUIModelBuilder setModel(ConfigUIModel model) throws IllegalStateException {
        this.checkNoCurrent(model, "model");
        this.model = model;
        if (log.isDebugEnabled()) {
            log.debug((Object)("new current model : " + this.model));
        }
        this.category = null;
        this.categoryDefaultCallBack = null;
        this.option = null;
        return this;
    }

    public ConfigUIModelBuilder setCategory(CategoryModel categoryModel) throws IllegalStateException {
        this.checkCurrent(this.model, "model");
        this.checkNoCurrent(this.category, "category");
        this.category = categoryModel;
        this.categoryDefaultCallBack = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("new current category : " + this.category));
        }
        this.option = null;
        return this;
    }

    public ConfigUIModelBuilder setOption(OptionModel optionModel) throws IllegalStateException {
        this.checkCurrent(this.model, "model");
        this.checkCurrent(this.category, "category");
        this.checkNoCurrent(this.option, "option");
        this.option = optionModel;
        if (log.isDebugEnabled()) {
            log.debug((Object)("new current option : " + this.option));
        }
        return this;
    }

    public ConfigUIModelBuilder setCloseAction(Runnable runnable) {
        this.checkNotNull(runnable, "setCloseAction", "runnable");
        this.checkCurrent(this.model, "model");
        this.model.setCloseAction(runnable);
        return this;
    }

    protected CategoryModel flushCategory() {
        CategoryModel result = this.category;
        if (this.category != null) {
            this.flushOption();
            this.model.addCategory(this.category);
            this.category = null;
            this.categoryDefaultCallBack = null;
        }
        return result;
    }

    protected OptionModel flushOption() {
        OptionModel result = this.option;
        if (this.option != null) {
            this.category.addOption(this.option);
            this.option = null;
        }
        return result;
    }

    protected void checkCurrent(Object o, String type) {
        if (o == null) {
            throw new IllegalStateException("no current " + type + "!");
        }
    }

    protected void checkNoCurrent(Object o, String type) {
        if (o != null) {
            throw new IllegalStateException("there is already a current " + type + "!");
        }
    }

    protected void checkNotNull(Object o, String method, String parameter) {
        if (o == null) {
            throw new NullPointerException("method " + method + " does not support null parameter " + parameter + "!");
        }
    }
}

