/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.choice;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.jaxx.widgets.choice.BooleanEditorHandler;
import java.util.Objects;
import javax.swing.JComboBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;

public class BooleanEditor
extends JComboBox<ValueEntry>
implements BeanScopeAware {
    private static final Logger log = LogManager.getLogger(BooleanEditor.class);
    private static final long serialVersionUID = 1L;
    private final BooleanEditorHandler handler = new BooleanEditorHandler();
    private String property;
    private JavaBean bean;

    public BooleanEditor() {
        this(null, null, null);
    }

    public BooleanEditor(String nullLibelle, String falseLibelle, String trueLibelle) {
        super(new ValueEntry[]{new ValueEntry(Value.NULL, nullLibelle), new ValueEntry(Value.FALSE, falseLibelle), new ValueEntry(Value.TRUE, trueLibelle)});
    }

    public void init() {
        this.handler.init(this);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.handler.checkNotInit();
        log.debug(String.format("%s - set property: %s", this.getName(), property));
        this.property = property;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.handler.checkNotInit();
        log.debug(String.format("%s - set bean: %s", this.getName(), bean));
        this.bean = (JavaBean)bean;
    }

    public Boolean getBooleanValue() {
        Object o = this.getSelectedItem();
        if (o == null) {
            return null;
        }
        ValueEntry v = (ValueEntry)o;
        return v.getValue().getBooleanValue();
    }

    public void setBooleanValue(Boolean b) {
        Value v = Value.valueOf(b);
        ValueEntry e = (ValueEntry)this.dataModel.getElementAt(v.ordinal());
        this.setSelectedItem(e);
    }

    protected static class ValueEntry {
        protected final Value value;
        protected final String text;

        ValueEntry(Value value, String text) {
            this.value = Objects.requireNonNull(value);
            this.text = I18n.t((String)(text == null ? value.getDefaultLibelle() : text), (Object[])new Object[0]);
        }

        public Value getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueEntry)) {
                return false;
            }
            ValueEntry that = (ValueEntry)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value});
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Value {
        NULL(I18n.n((String)"boolean.null", (Object[])new Object[0]), null),
        FALSE(I18n.n((String)"boolean.false", (Object[])new Object[0]), false),
        TRUE(I18n.n((String)"boolean.true", (Object[])new Object[0]), true);

        private final String defaultLibelle;
        private final Boolean booleanValue;

        private Value(String defaultLibelle, Boolean booleanValue) {
            this.defaultLibelle = defaultLibelle;
            this.booleanValue = booleanValue;
        }

        public static Value valueOf(Boolean value) {
            Value result = null;
            for (Value v : Value.values()) {
                if (v.getBooleanValue() != value) continue;
                result = v;
                break;
            }
            return result;
        }

        public Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public String getDefaultLibelle() {
            return this.defaultLibelle;
        }
    }
}

