/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.choice;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import io.ultreia.java4all.jaxx.widgets.choice.BeanCheckBox;
import java.util.Objects;
import javax.swing.JCheckBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class BeanCheckBoxHandler
extends BeanUIHandlerSupport<BeanCheckBox> {
    private static final Logger log = LogManager.getLogger(BeanCheckBoxHandler.class);

    BeanCheckBoxHandler() {
    }

    @Override
    protected String getProperty(BeanCheckBox ui) {
        return ui.getProperty();
    }

    @Override
    protected void prepareInit(String property) {
        log.debug(String.format("%s - init BeanCheckBox", ((BeanCheckBox)this.ui).getName()));
        if (property == null || property.isEmpty()) {
            ((BeanCheckBox)this.ui).setProperty(((BeanCheckBox)this.ui).getName());
        }
    }

    @Override
    protected void prepareBindFromBean(String property, JavaBean bean) {
        bean.addPropertyChangeListener(property, e -> {
            boolean oldValue = ((BeanCheckBox)this.ui).isSelected();
            boolean newValue = Boolean.TRUE.equals(e.getNewValue());
            if (!Objects.equals(oldValue, newValue)) {
                log.debug(String.format("%s - [%s] get new value from bean: %s", ((BeanCheckBox)this.ui).getName(), property, newValue));
                ((BeanCheckBox)this.ui).setSelected(newValue);
            }
        });
        Boolean value = (Boolean)bean.get(property);
        ((BeanCheckBox)this.ui).setSelected(Objects.equals(Boolean.TRUE, value));
    }

    @Override
    protected void prepareBindToBean(String property, JavaBean bean) {
        ((BeanCheckBox)this.ui).addItemListener(event -> {
            boolean newValue = ((JCheckBox)event.getSource()).isSelected();
            log.debug(String.format("%s - [%s] set new value to bean: %s", ((BeanCheckBox)this.ui).getName(), property, newValue));
            bean.set(property, (Object)newValue);
        });
    }
}

