/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.choice;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import io.ultreia.java4all.jaxx.widgets.choice.BooleanEditor;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class BooleanEditorHandler
extends BeanUIHandlerSupport<BooleanEditor> {
    private static final Logger log = LogManager.getLogger(BooleanEditorHandler.class);

    BooleanEditorHandler() {
    }

    @Override
    protected String getProperty(BooleanEditor ui) {
        return ui.getProperty();
    }

    @Override
    protected void prepareInit(String property) {
        log.debug(String.format("%s - init BooleanEditor", ((BooleanEditor)this.ui).getName()));
        if (property == null || property.isEmpty()) {
            ((BooleanEditor)this.ui).setProperty(((BooleanEditor)this.ui).getName());
        }
    }

    @Override
    protected void prepareBindFromBean(String property, JavaBean bean) {
        bean.addPropertyChangeListener(property, e -> {
            Boolean newValue;
            Boolean oldValue = ((BooleanEditor)this.ui).getBooleanValue();
            if (!Objects.equals(oldValue, newValue = (Boolean)e.getNewValue())) {
                log.debug(String.format("%s - [%s] get new value from bean: %s", ((BooleanEditor)this.ui).getName(), property, newValue));
                ((BooleanEditor)this.ui).setBooleanValue(newValue);
            }
        });
    }

    @Override
    protected void prepareBindToBean(String property, JavaBean bean) {
        ((BooleanEditor)this.ui).addItemListener(event -> {
            if (event.getStateChange() == 1) {
                Boolean newValue = ((BooleanEditor)event.getSource()).getBooleanValue();
                log.debug(String.format("%s - [%s] set new value to bean: %s", ((BooleanEditor)this.ui).getName(), property, newValue));
                bean.set(property, (Object)newValue);
            }
        });
    }
}

