/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import com.google.common.collect.ImmutableMap;
import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.combobox.BeanEnumEditorHandler;
import java.util.EnumSet;
import java.util.function.Function;
import javax.swing.ListCellRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.swing.editor.EnumEditor;
import org.nuiton.jaxx.runtime.swing.renderer.EnumEditorRenderer;

public class BeanEnumEditor<B extends Enum<B>>
extends EnumEditor<B>
implements BeanScopeAware {
    private static final Logger log = LogManager.getLogger(BeanEnumEditor.class);
    final boolean useIndex;
    private final BeanEnumEditorHandler<B> handler;
    private String property;
    private JavaBean bean;

    public BeanEnumEditor(Class<B> type) {
        this(type, false);
    }

    public BeanEnumEditor(Class<B> type, boolean useIndex) {
        super(type);
        this.useIndex = useIndex;
        this.handler = new BeanEnumEditorHandler();
    }

    public BeanEnumEditor(Class<B> type, int maxOrdinal) {
        this(type, maxOrdinal, false);
    }

    public BeanEnumEditor(Class<B> type, int maxOrdinal, boolean useIndex) {
        super(type, maxOrdinal);
        this.useIndex = useIndex;
        this.handler = new BeanEnumEditorHandler();
    }

    public void init(Function<B, String> labelFunction) {
        this.handler.init(this);
        ImmutableMap.Builder labelsBuilder = ImmutableMap.builder();
        for (Enum e : EnumSet.allOf(this.getType())) {
            String label = labelFunction.apply(e);
            labelsBuilder.put((Object)e, (Object)label);
        }
        this.setRenderer((ListCellRenderer)new EnumEditorRenderer(labelsBuilder.build()));
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.handler.checkNotInit();
        log.debug(String.format("%s - set property: %s", this.getName(), property));
        this.property = property;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.handler.checkNotInit();
        log.debug(String.format("%s - set bean: %s", this.getName(), this.property));
        this.bean = (JavaBean)bean;
    }
}

