/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import io.ultreia.java4all.lang.Objects2;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;

public class Setters {
    public static Set<String> getWriteableProperties(Class<?> beanType) {
        Objects.requireNonNull(beanType);
        final HashSet<String> result = new HashSet<String>();
        Objects2.walk((Objects2.ClassWalkVisitor)new Objects2.ClassWalkVisitor(){

            public void onVisit(Class<?> beanType) {
                for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors(beanType)) {
                    if (!Objects2.IS_WRITE_DESCRIPTOR.test(descriptor)) continue;
                    result.add(descriptor.getName());
                }
            }

            public boolean canContinue() {
                return true;
            }
        }, beanType);
        return result;
    }

    public static Method getMutator(Object bean, String property) {
        Objects.requireNonNull(bean);
        Objects.requireNonNull(property);
        Method mutator = null;
        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)property);
            if (descriptor != null) {
                mutator = descriptor.getWriteMethod();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mutator;
    }
}

