/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.jformattedtextfield;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.widgets.jformattedtextfield.JFormatterTextFieldInternalGroup;

public class JFormatterTextFieldInternalGroups
implements Iterable<JFormatterTextFieldInternalGroup> {
    private static final Logger log = LogManager.getLogger(JFormatterTextFieldInternalGroups.class);
    private final Set<JFormatterTextFieldInternalGroup> componentPositions;

    public static JFormatterTextFieldInternalGroups create(String mask) {
        mask = mask.replaceAll("''", "'");
        LinkedHashSet<JFormatterTextFieldInternalGroup> groups = new LinkedHashSet<JFormatterTextFieldInternalGroup>();
        JFormatterTextFieldInternalGroup previousGroup = null;
        int length = mask.length();
        for (int i = 0; i < length; ++i) {
            char c = mask.charAt(i);
            if (c == '*') continue;
            int endIndex = i - 1;
            int endGroupIndex = JFormatterTextFieldInternalGroups.getGroupLastIndex(mask, i, length);
            i = endGroupIndex + 1;
            previousGroup = JFormatterTextFieldInternalGroups.addGroup(groups, previousGroup, endIndex, endGroupIndex);
        }
        if (previousGroup != null && previousGroup.getEndGroupIndex() < length - 1) {
            JFormatterTextFieldInternalGroups.addGroup(groups, previousGroup, length, length);
        }
        return new JFormatterTextFieldInternalGroups(groups);
    }

    protected static int getGroupLastIndex(String mask, int i, int length) {
        char c2;
        while ((c2 = mask.charAt(i)) != '*' && ++i < length) {
        }
        return i - 1;
    }

    protected static JFormatterTextFieldInternalGroup addGroup(Set<JFormatterTextFieldInternalGroup> componentPositions, JFormatterTextFieldInternalGroup previousGroup, int endIndex, int endSymbolIndex) {
        boolean withPreviousGroup = previousGroup != null;
        JFormatterTextFieldInternalGroup newGroup = withPreviousGroup ? new JFormatterTextFieldInternalGroup(previousGroup.getEndGroupIndex() + 1, endIndex, endSymbolIndex) : new JFormatterTextFieldInternalGroup(0, endIndex, endSymbolIndex);
        if (log.isDebugEnabled()) {
            log.debug(String.format("New component (%d): %d - %d - %d", componentPositions.size(), newGroup.getStartIndex(), newGroup.getEndIndex(), newGroup.getEndGroupIndex()));
        }
        componentPositions.add(newGroup);
        if (withPreviousGroup) {
            previousGroup.setNextGroup(newGroup);
            newGroup.setPreviousGroup(previousGroup);
        }
        return newGroup;
    }

    public JFormatterTextFieldInternalGroup getGroupAtPosition(int position) {
        JFormatterTextFieldInternalGroup result = null;
        for (JFormatterTextFieldInternalGroup componentPosition : this) {
            if (!componentPosition.containsPosition(position)) continue;
            result = componentPosition;
            break;
        }
        return result;
    }

    protected JFormatterTextFieldInternalGroups(Set<JFormatterTextFieldInternalGroup> componentPositions) {
        this.componentPositions = ImmutableSet.copyOf(componentPositions);
    }

    @Override
    public Iterator<JFormatterTextFieldInternalGroup> iterator() {
        return this.componentPositions.iterator();
    }
}

