/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.jformattedtextfield;

import com.google.common.base.Preconditions;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.MaskFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.widgets.jformattedtextfield.JFormatterTextFieldInternalGroup;
import org.nuiton.jaxx.widgets.jformattedtextfield.JFormatterTextFieldInternalGroups;

public class JFormattedTextFieldNavigationManager {
    private static final Logger log = LogManager.getLogger(JFormattedTextFieldNavigationManager.class);
    private static final String CLIENT_PROPERTY_NAVIGATION_MANAGER = "JFormattedTextFieldNavigationHandler";
    private final JFormatterTextFieldInternalGroups groups;
    private final KeyAdapter keyAdapter;
    private final MouseAdapter mouseAdapter;
    private final FocusAdapter focusAdapter;
    private final Map<JFormatterTextFieldInternalGroup, SelectComponentAction> actions;
    private JFormatterTextFieldInternalGroup lastGroup = null;

    public static void install(JFormattedTextField component) {
        JFormattedTextField.AbstractFormatter formatter = component.getFormatter();
        Preconditions.checkState((formatter != null ? 1 : 0) != 0, (Object)("No formatter found on " + component));
        Preconditions.checkState((boolean)(formatter instanceof MaskFormatter), (Object)("Formatter " + formatter + " is not a MaskFormatter"));
        String mask = ((MaskFormatter)formatter).getMask();
        JFormatterTextFieldInternalGroups componentPositions = JFormatterTextFieldInternalGroups.create(mask);
        JFormattedTextFieldNavigationManager handler = new JFormattedTextFieldNavigationManager(componentPositions, component);
        component.putClientProperty(CLIENT_PROPERTY_NAVIGATION_MANAGER, handler);
        handler.install0(component);
    }

    public static void uninstall(JFormattedTextField component) {
        JFormattedTextFieldNavigationManager handler = (JFormattedTextFieldNavigationManager)component.getClientProperty(CLIENT_PROPERTY_NAVIGATION_MANAGER);
        try {
            handler.uninstall0(component);
        }
        finally {
            component.putClientProperty(CLIENT_PROPERTY_NAVIGATION_MANAGER, null);
        }
    }

    protected JFormattedTextFieldNavigationManager(JFormatterTextFieldInternalGroups groups, JFormattedTextField component) {
        this.groups = groups;
        this.actions = new HashMap<JFormatterTextFieldInternalGroup, SelectComponentAction>();
        for (JFormatterTextFieldInternalGroup componentPosition : groups) {
            this.actions.put(componentPosition, new SelectComponentAction(component, componentPosition));
        }
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JFormattedTextField source = (JFormattedTextField)e.getSource();
                int caretPosition = source.getCaretPosition();
                if (JFormattedTextFieldNavigationManager.this.canGoRight(e)) {
                    JFormattedTextFieldNavigationManager.this.goRight(source, caretPosition);
                    e.consume();
                } else if (JFormattedTextFieldNavigationManager.this.canTransferFocus(e)) {
                    source.transferFocus();
                    e.consume();
                } else if (JFormattedTextFieldNavigationManager.this.canGoLeft(e)) {
                    JFormattedTextFieldNavigationManager.this.goLeft(source, caretPosition);
                    e.consume();
                } else if (JFormattedTextFieldNavigationManager.this.canTransferFocusBackward(e)) {
                    source.transferFocusBackward();
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                JFormattedTextField source = (JFormattedTextField)e.getSource();
                JFormatterTextFieldInternalGroup currentGroup = JFormattedTextFieldNavigationManager.this.getCurrentGroup(source);
                JFormattedTextFieldNavigationManager.this.selectComponent(currentGroup);
            }
        };
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JFormattedTextField source = (JFormattedTextField)e.getSource();
                JFormatterTextFieldInternalGroup currentGroup = JFormattedTextFieldNavigationManager.this.getCurrentGroup(source);
                JFormattedTextFieldNavigationManager.this.selectComponent(currentGroup);
            }
        };
        this.focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JFormattedTextFieldNavigationManager.this.lastGroup = null;
                JFormattedTextField source = (JFormattedTextField)e.getSource();
                JFormatterTextFieldInternalGroup currentGroup = JFormattedTextFieldNavigationManager.this.getCurrentGroup(source);
                JFormattedTextFieldNavigationManager.this.selectComponent(currentGroup);
            }
        };
    }

    protected void gotoComponent(JFormattedTextField source, JFormatterTextFieldInternalGroup group) {
        if (group != null) {
            int startIndex = group.getStartIndex();
            int endIndex = group.getEndIndex();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Goto component [%s - %s]", startIndex, endIndex));
            }
            source.setCaretPosition(startIndex);
        }
    }

    protected void selectComponent(JFormatterTextFieldInternalGroup currentGroup) {
        if (this.lastGroup == null || !this.lastGroup.equals(currentGroup)) {
            if (log.isDebugEnabled()) {
                log.debug("New select group: " + currentGroup);
            }
            this.lastGroup = currentGroup;
            SelectComponentAction action = this.actions.get(currentGroup);
            SwingUtilities.invokeLater(action);
        }
    }

    protected JFormatterTextFieldInternalGroup getCurrentGroup(JFormattedTextField source) {
        int caretPosition = source.getCaretPosition();
        return this.groups.getGroupAtPosition(caretPosition);
    }

    protected void goRight(JFormattedTextField source, int caretPosition) {
        if (this.lastGroup == null || !this.lastGroup.isLastGroup()) {
            if (log.isDebugEnabled()) {
                log.debug("Go right from position " + caretPosition);
            }
            JFormatterTextFieldInternalGroup currentGroup = this.groups.getGroupAtPosition(caretPosition);
            JFormatterTextFieldInternalGroup nextGroup = currentGroup.getNextGroup();
            this.gotoComponent(source, nextGroup);
        }
    }

    protected void goLeft(JFormattedTextField source, int caretPosition) {
        if (this.lastGroup == null || !this.lastGroup.isFirstGroup()) {
            if (log.isDebugEnabled()) {
                log.debug("Go left from position " + caretPosition);
            }
            JFormatterTextFieldInternalGroup currentGroup = this.groups.getGroupAtPosition(caretPosition);
            JFormatterTextFieldInternalGroup nextGroup = currentGroup.getPreviousGroup();
            this.gotoComponent(source, nextGroup);
        }
    }

    protected boolean canGoRight(KeyEvent e) {
        boolean noModifiers;
        boolean result = false;
        boolean bl = noModifiers = e.getModifiers() == 0;
        if (39 == e.getKeyCode() && noModifiers) {
            result = true;
        } else if (9 == e.getKeyCode() && noModifiers) {
            result = this.lastGroup == null || !this.lastGroup.isLastGroup();
        }
        return result;
    }

    protected boolean canGoLeft(KeyEvent e) {
        boolean result = false;
        if (37 == e.getKeyCode() && e.getModifiers() == 0) {
            result = true;
        } else if (9 == e.getKeyCode() && e.isShiftDown() && !e.isControlDown()) {
            result = this.lastGroup != null && !this.lastGroup.isFirstGroup();
        }
        return result;
    }

    protected boolean canTransferFocus(KeyEvent e) {
        boolean onTabKey;
        boolean result = false;
        boolean bl = onTabKey = 9 == e.getKeyCode();
        if (onTabKey && e.isControlDown() && !e.isShiftDown()) {
            result = true;
        } else if (onTabKey && e.getModifiers() == 0) {
            result = this.lastGroup != null && this.lastGroup.isLastGroup();
        }
        return result;
    }

    protected boolean canTransferFocusBackward(KeyEvent e) {
        boolean onShiftTabKey;
        boolean result = false;
        boolean bl = onShiftTabKey = 9 == e.getKeyCode() && e.isShiftDown();
        if (onShiftTabKey && e.isControlDown()) {
            result = true;
        } else if (onShiftTabKey) {
            result = this.lastGroup == null || this.lastGroup.isFirstGroup();
        }
        return result;
    }

    private void install0(JFormattedTextField component) {
        component.setFocusTraversalKeysEnabled(false);
        component.addKeyListener(this.keyAdapter);
        component.addMouseListener(this.mouseAdapter);
        component.addFocusListener(this.focusAdapter);
    }

    private void uninstall0(JFormattedTextField component) {
        component.setFocusTraversalKeysEnabled(true);
        component.removeKeyListener(this.keyAdapter);
        component.removeMouseListener(this.mouseAdapter);
        component.removeFocusListener(this.focusAdapter);
    }

    private static class SelectComponentAction
    implements Runnable {
        private final JFormatterTextFieldInternalGroup group;
        private final JFormattedTextField source;

        private SelectComponentAction(JFormattedTextField source, JFormatterTextFieldInternalGroup group) {
            this.group = group;
            this.source = source;
        }

        @Override
        public void run() {
            int startIndex = this.group.getStartIndex();
            int endIndex = this.group.getEndIndex() + 1;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Select group [%s]", this.group));
            }
            this.source.select(startIndex, endIndex);
        }
    }
}

