/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing.tab;

import java.awt.Component;
import java.awt.Container;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.awt.Containers;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableModel;
import org.nuiton.validator.NuitonValidatorScope;

public class TabInfoWithValidator
extends TabInfo {
    private static final Icon FATAL_ICON = UIManager.getIcon("action.fatal");
    private static final Icon ERROR_ICON = UIManager.getIcon("action.error");
    private static final Icon WARNING_ICON = UIManager.getIcon("action.warning");
    private static final Icon INFO_ICON = UIManager.getIcon("action.info");
    private final Map<String, Component> components = new LinkedHashMap<String, Component>();
    private final Map<String, Component> validatorComponents = new LinkedHashMap<String, Component>();
    private final Set<String> validatorComponentIds = new LinkedHashSet<String>();
    private SwingValidator<?> validator;
    private String validatorId;
    private JTabbedPane parent;
    private boolean withFatal;
    private boolean withError;
    private boolean withWarning;
    private boolean withInfo;

    public TabInfoWithValidator(String id) {
        super(id);
    }

    public static void onTableModelChanged(TabInfoWithValidator component, SwingValidatorMessageTableModel errorTableModel) {
        int rowCount = errorTableModel.getRowCount();
        LinkedHashSet<NuitonValidatorScope> scopes = new LinkedHashSet<NuitonValidatorScope>();
        Set<String> validatorComponentIds = component.getValidatorComponentIds();
        for (int i = 0; i < rowCount; ++i) {
            SwingValidatorMessage row = errorTableModel.getRow(i);
            if (!validatorComponentIds.contains(row.getField())) continue;
            scopes.add(row.getScope());
        }
        component.setWithFatal(scopes.contains(NuitonValidatorScope.FATAL));
        component.setWithError(scopes.contains(NuitonValidatorScope.ERROR));
        component.setWithWarning(scopes.contains(NuitonValidatorScope.WARNING));
        component.setWithInfo(scopes.contains(NuitonValidatorScope.INFO));
        if (component.isWithFatal()) {
            component.setIcon(FATAL_ICON);
        } else if (component.isWithError()) {
            component.setIcon(ERROR_ICON);
        } else if (component.isWithWarning()) {
            component.setIcon(WARNING_ICON);
        } else if (component.isWithInfo()) {
            component.setIcon(INFO_ICON);
        } else {
            component.setIcon(null);
        }
    }

    public boolean isWithFatal() {
        return this.withFatal;
    }

    public void setWithFatal(boolean withFatal) {
        this.withFatal = withFatal;
    }

    public boolean isWithError() {
        return this.withError;
    }

    public void setWithError(boolean withError) {
        this.withError = withError;
    }

    public boolean isWithWarning() {
        return this.withWarning;
    }

    public void setWithWarning(boolean withWarning) {
        this.withWarning = withWarning;
    }

    public boolean isWithInfo() {
        return this.withInfo;
    }

    public void setWithInfo(boolean withInfo) {
        this.withInfo = withInfo;
    }

    public SwingValidator getValidator() {
        return this.validator;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public void setValidatorId(String validatorId) {
        this.validatorId = validatorId;
    }

    public Map<String, Component> getComponents() {
        return this.components;
    }

    public Map<String, Component> getValidatorComponents() {
        return this.validatorComponents;
    }

    public Set<String> getValidatorComponentIds() {
        return this.validatorComponentIds;
    }

    public JTabbedPane getParent() {
        return this.parent;
    }

    public void init(JAXXObject ui, JTabbedPane parent) {
        this.parent = parent;
        this.setTabComponent((JComponent)Objects.requireNonNull(parent.getComponentAt(this.getTabIndex())));
        this.validator = (SwingValidator)((Object)Objects.requireNonNull(Objects.requireNonNull(ui).getObjectById(this.getValidatorId())));
        Set effectiveFields = this.validator.getEffectiveFields();
        this.components.clear();
        this.validatorComponents.clear();
        this.validatorComponentIds.clear();
        for (Component component : Containers.findComponents((Container)this.getTabComponent(), c -> true)) {
            String name = component.getName();
            this.components.put(name, component);
            if (!effectiveFields.contains(name)) continue;
            this.validatorComponents.put(name, component);
            this.validatorComponentIds.add(name);
        }
    }

    public static class TabTableModelListener
    implements TableModelListener {
        private final TabInfoWithValidator component;

        public TabTableModelListener(TabInfoWithValidator component) {
            this.component = component;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            SwingValidatorMessageTableModel errorTableModel = (SwingValidatorMessageTableModel)e.getSource();
            TabInfoWithValidator.onTableModelChanged(this.component, errorTableModel);
        }

        public TabInfoWithValidator getComponent() {
            return this.component;
        }
    }
}

