/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import io.ultreia.java4all.i18n.I18n;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.SimpleBeanValidatorMessageTableRenderer;
import org.nuiton.jaxx.validator.swing.SwingListValidatorDataLocator;
import org.nuiton.jaxx.validator.swing.SwingListValidatorHighlightPredicate;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableModel;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableMouseListener;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableRenderer;
import org.nuiton.jaxx.validator.swing.SwingListValidatorTableEditorModelListener;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageListMouseListener;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableModel;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableMouseListener;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableRenderer;
import org.nuiton.jaxx.validator.swing.tab.TabInfoWithValidator;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.list.BeanListValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorMessage;
import org.nuiton.validator.bean.simple.SimpleBeanValidators;

public class SwingValidatorUtil
extends SimpleBeanValidators {
    private static final Logger log = LogManager.getLogger(SwingValidatorUtil.class);
    protected static EnumMap<NuitonValidatorScope, ImageIcon> icons;
    protected static EnumMap<NuitonValidatorScope, Color> colors;

    public static EnumMap<NuitonValidatorScope, ImageIcon> getIcons() {
        if (icons == null) {
            icons = new EnumMap(NuitonValidatorScope.class);
            icons.put(NuitonValidatorScope.FATAL, SwingUtil.createImageIcon((String)"fatal.png"));
            icons.put(NuitonValidatorScope.ERROR, SwingUtil.createImageIcon((String)"error.png"));
            icons.put(NuitonValidatorScope.WARNING, SwingUtil.createImageIcon((String)"warning.png"));
            icons.put(NuitonValidatorScope.INFO, SwingUtil.createImageIcon((String)"info.png"));
        }
        return icons;
    }

    public static EnumMap<NuitonValidatorScope, Color> getColors() {
        if (colors == null) {
            colors = new EnumMap(NuitonValidatorScope.class);
            colors.put(NuitonValidatorScope.FATAL, Color.MAGENTA);
            colors.put(NuitonValidatorScope.ERROR, Color.RED);
            colors.put(NuitonValidatorScope.WARNING, Color.YELLOW);
            colors.put(NuitonValidatorScope.INFO, Color.GREEN);
        }
        return colors;
    }

    public static Color getColor(NuitonValidatorScope scope) {
        return scope == null ? null : SwingValidatorUtil.getColors().get(scope);
    }

    public static ImageIcon getIcon(NuitonValidatorScope scope) {
        return scope == null ? null : SwingValidatorUtil.getIcons().get(scope);
    }

    public static ImageIcon getFatalIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.FATAL);
    }

    public static ImageIcon getErrorIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.ERROR);
    }

    public static ImageIcon getWarningIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.WARNING);
    }

    public static ImageIcon getInfoIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.INFO);
    }

    public static <O> SwingValidator<O> newValidator(Class<O> type, String context) {
        return SwingValidator.newValidator(type, context, new NuitonValidatorScope[0]);
    }

    @Deprecated
    public static void installUI(JAXXValidator ui) {
        ui.installValidationUI();
    }

    public static void installUI(JTable errorTable, SwingValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer((JTable)errorTable, (String[])new String[]{I18n.n((String)"validator.scope.header", (Object[])new Object[0]), I18n.n((String)"validator.scope.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.field.header", (Object[])new Object[0]), I18n.n((String)"validator.field.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.message.header", (Object[])new Object[0]), I18n.n((String)"validator.message.header.tip", (Object[])new Object[0])});
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        SwingUtil.fixTableColumnWidth((JTable)errorTable, (int)0, (int)25);
    }

    public static void installUI(JTable errorTable, SimpleBeanValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer((JTable)errorTable, (String[])new String[]{I18n.n((String)"validator.scope.header", (Object[])new Object[0]), I18n.n((String)"validator.scope.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.field.header", (Object[])new Object[0]), I18n.n((String)"validator.field.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.message.header", (Object[])new Object[0]), I18n.n((String)"validator.message.header.tip", (Object[])new Object[0])});
        SwingUtil.fixTableColumnWidth((JTable)errorTable, (int)0, (int)25);
    }

    public static void installUI(JTable errorTable, SwingListValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer((JTable)errorTable, (String[])new String[]{I18n.n((String)"validator.scope.header", (Object[])new Object[0]), I18n.n((String)"validator.scope.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.bean.header", (Object[])new Object[0]), I18n.n((String)"validator.bean.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.field.header", (Object[])new Object[0]), I18n.n((String)"validator.field.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.message.header", (Object[])new Object[0]), I18n.n((String)"validator.message.header.tip", (Object[])new Object[0])});
        SwingUtil.fixTableColumnWidth((JTable)errorTable, (int)0, (int)25);
    }

    @Deprecated
    public static void installTabUI(JAXXValidator ui, TabInfoWithValidator tab) {
        ui.installTabUI(tab);
    }

    @Deprecated
    public static void uninstallTabUI(JAXXValidator ui, Collection<TabInfoWithValidator> tabEditors, SwingValidatorMessageTableModel errorTableModel) {
        ui.uninstallTabUI(tabEditors, errorTableModel);
    }

    public static <O> void registerListValidator(BeanListValidator<O> validator, SwingListValidatorMessageTableModel errorTableModel, JTable dataTable, JTable errorTable, SwingListValidatorDataLocator<O> dataLocator) {
        errorTableModel.registerValidator(validator);
        errorTable.addMouseListener(new SwingListValidatorMessageTableMouseListener(dataTable, dataLocator));
        dataTable.getModel().addTableModelListener(new SwingListValidatorTableEditorModelListener<O>(validator, dataLocator));
    }

    public static <O> void addHightLighterOnEditor(BeanListValidator<O> validator, JXTable editor, SwingListValidatorDataLocator<O> dataLocator, NuitonValidatorScope ... scopes) {
        for (NuitonValidatorScope scope : scopes) {
            SwingListValidatorHighlightPredicate<O> predicate = SwingListValidatorHighlightPredicate.newPredicate(scope, validator, dataLocator);
            ColorHighlighter highlighter = new ColorHighlighter(predicate);
            highlighter.setBackground(SwingValidatorUtil.getColor(scope));
            editor.addHighlighter((Highlighter)highlighter);
        }
    }

    public static SwingValidatorMessageListMouseListener registerErrorListMouseListener(JList<?> list) {
        SwingValidatorMessageListMouseListener listener = SwingValidatorUtil.getErrorListMouseListener(list);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageListMouseListener();
        log.debug(listener.toString());
        list.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageTableMouseListener registerErrorTableMouseListener(JTable table) {
        SwingValidatorMessageTableMouseListener listener = SwingValidatorUtil.getErrorTableMouseListener(table);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageTableMouseListener();
        log.debug(listener.toString());
        table.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageListMouseListener getErrorListMouseListener(JList<?> list) {
        if (list != null) {
            for (MouseListener listener : list.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageListMouseListener)) continue;
                return (SwingValidatorMessageListMouseListener)listener;
            }
        }
        return null;
    }

    public static SwingValidatorMessageTableMouseListener getErrorTableMouseListener(JTable table) {
        if (table != null) {
            for (MouseListener listener : table.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageTableMouseListener)) continue;
                return (SwingValidatorMessageTableMouseListener)listener;
            }
        }
        return null;
    }

    public static SwingValidatorMessageTableMouseListener getListErrorTableMouseListener(JTable table) {
        if (table != null) {
            for (MouseListener listener : table.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageTableMouseListener)) continue;
                return (SwingValidatorMessageTableMouseListener)listener;
            }
        }
        return null;
    }

    public static String getMessage(SwingValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getI18nError(text);
        }
        return text;
    }

    public static String getMessage(SimpleBeanValidatorMessage<?> model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getI18nError(text);
        }
        return text;
    }

    public static String getMessage(SwingListValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getI18nError(text);
        }
        return text;
    }

    public static String getFieldName(SwingValidatorMessage model, String value) {
        String text = null;
        JComponent editor = model.getEditor();
        if (editor != null) {
            text = (String)editor.getClientProperty("validatorLabel");
        }
        if (text == null) {
            text = value;
        }
        return text;
    }

    public static String getFieldName(SwingListValidatorMessage model, String value) {
        String text = null;
        JComponent editor = model.getEditor();
        if (editor != null) {
            text = (String)editor.getClientProperty("validatorLabel");
        }
        if (text == null) {
            text = value;
        }
        return text;
    }

    @Deprecated
    public static void listenValidatorContextNameAndRefreshFields(SwingValidator<?> validator, JAXXValidator ui) {
        ui.listenValidatorContextNameAndRefreshFields(validator);
    }

    @Deprecated
    public static void setValidatorBean(JAXXObject ui, Object bean, String ... excludeIds) {
        if (!JAXXValidator.class.isAssignableFrom(ui.getClass())) {
            return;
        }
        JAXXValidator jaxxValidator = (JAXXValidator)ui;
        jaxxValidator.setValidatorBean(bean, excludeIds);
    }

    @Deprecated
    public static void setValidatorChanged(JAXXObject ui, boolean newValue, String ... excludeIds) {
        if (!JAXXValidator.class.isAssignableFrom(ui.getClass())) {
            return;
        }
        JAXXValidator jaxxValidator = (JAXXValidator)ui;
        jaxxValidator.setValidatorChanged(newValue, excludeIds);
    }

    protected SwingValidatorUtil() {
    }
}

