package org.nuiton.jaxx.validator;

/*-
 * #%L
 * JAXX :: Validator
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;

/**
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3
 */
public class ValidatorUtil {
    public static void addFieldError(FieldValidatorSupport validator, ValueStack stack, String propertyName, Object object) {
        boolean pop = false;
        if (!stack.getRoot().contains(validator)) {
            stack.push(validator);
            pop = true;
        }
        try {
            validator.getValidatorContext().addFieldError(propertyName, validator.getMessage(object));
        } finally {
            if (pop) {
                stack.pop();
            }
        }
    }
}
