/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableModel;

public class SwingValidatorMessageTableMouseListener
extends MouseAdapter {
    public static final String HIGHLIGHT_ERROR_PROPERTY = "highlightError";
    private static final Logger log = LogManager.getLogger(SwingValidatorMessageTableMouseListener.class);
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2) {
            SwingValidatorMessage entry = this.getSelectedMessage(e);
            if (entry == null) {
                return;
            }
            JComponent component = entry.getEditor();
            if (component != null) {
                this.pcs.firePropertyChange(HIGHLIGHT_ERROR_PROPERTY, null, (Object)entry);
                if (component.isVisible()) {
                    component.requestFocusInWindow();
                }
            }
        }
    }

    protected SwingValidatorMessage getSelectedMessage(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        if (!(table.getModel() instanceof SwingValidatorMessageTableModel)) {
            if (log.isWarnEnabled()) {
                log.warn("model must be a " + SwingValidatorMessageTableModel.class + ", but was " + table.getModel());
            }
            return null;
        }
        SwingValidatorMessageTableModel model = (SwingValidatorMessageTableModel)table.getModel();
        int index = table.getSelectionModel().getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        if (table.getRowSorter() != null) {
            index = table.getRowSorter().convertRowIndexToModel(index);
        }
        SwingValidatorMessage entry = model.getRow(index);
        if (log.isDebugEnabled()) {
            log.debug("selected index: " + index + " : error: " + entry);
        }
        return entry;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

