/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.event.TableModelListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableModel;
import org.nuiton.jaxx.validator.swing.ValidatorField;
import org.nuiton.jaxx.validator.swing.tab.TabInfoWithValidator;

public interface JAXXValidator {
    public static final Logger log = LogManager.getLogger(JAXXValidator.class);

    public SwingValidator<?> getValidator(String var1);

    public List<String> getValidatorIds();

    public ArrayListMultimap<JComponent, ValidatorField> getValidatorEditors();

    public ArrayListMultimap<JComponent, ValidatorField> createValidatorEditors();

    default public void registerValidatorFields() {
        ArrayListMultimap<JComponent, ValidatorField> validatorEditors = this.getValidatorEditors();
        this.setFieldRepresentation((Multimap<JComponent, ValidatorField>)validatorEditors);
    }

    default public Stream<SwingValidator<?>> validatorsStream(Predicate<String> idPredicate) {
        return this.getValidatorIds().stream().filter(idPredicate).map(this::getValidator);
    }

    default public void listenValidatorContextNameAndRefreshFields(SwingValidator<?> validator) {
        PropertyChangeListener listener = evt -> {
            SwingValidator validator1 = (SwingValidator)((Object)((Object)evt.getSource()));
            log.info(String.format("Context name changed to [%s] for validator %s", evt.getNewValue(), validator1.getType()));
            this.registerValidatorFields();
        };
        validator.addPropertyChangeListener("context", listener);
    }

    default public void setFieldRepresentation(Multimap<JComponent, ValidatorField> editors) {
        for (String validatorId : this.getValidatorIds()) {
            SwingValidator<?> validator = this.getValidator(validatorId);
            for (Map.Entry entry : editors.entries()) {
                String[] propertyNames;
                ValidatorField fieldAnnotation = (ValidatorField)entry.getValue();
                JComponent editor = (JComponent)entry.getKey();
                if (!validatorId.equals(fieldAnnotation.validatorId())) continue;
                for (String propertyName : propertyNames = fieldAnnotation.propertyName()) {
                    log.info(String.format("Detects for validator [%s] property %s for editor %s", validatorId, propertyName, fieldAnnotation.editorName()));
                    validator.setFieldRepresentation(propertyName, editor);
                }
            }
        }
    }

    default public void installValidationUI() {
        this.registerValidatorFields();
        this.validatorsStream(id -> true).filter(Objects::nonNull).forEach(validator -> {
            validator.installUIs();
            validator.reloadBean();
        });
    }

    default public void setValidatorBean(Object bean, String ... excludeIds) {
        List<String> validatorIds = this.getValidatorIds();
        if (excludeIds.length > 0) {
            validatorIds = new ArrayList<String>(validatorIds);
            for (String excludeId : excludeIds) {
                validatorIds.remove(excludeId);
            }
        }
        this.validatorsStream(validatorIds::contains).filter(v -> bean == null || v.getType().isAssignableFrom(bean.getClass())).forEach(validator -> validator.setBean(bean));
    }

    default public void setValidatorChanged(boolean newValue, String ... excludeIds) {
        ArrayList<String> validatorIds = new ArrayList<String>(this.getValidatorIds());
        if (excludeIds.length > 0) {
            for (String excludeId : excludeIds) {
                validatorIds.remove(excludeId);
            }
        }
        this.validatorsStream(validatorIds::contains).forEach(validator -> validator.setChanged(newValue));
    }

    default public void installTabUI(TabInfoWithValidator tab) {
        TabInfoWithValidator.TabTableModelListener listener = new TabInfoWithValidator.TabTableModelListener(tab);
        tab.getValidator().getErrorTableModel().addTableModelListener(listener);
    }

    default public void uninstallTabUI(Collection<TabInfoWithValidator> tabEditors, SwingValidatorMessageTableModel errorTableModel) {
        for (TableModelListener tableModelListener : errorTableModel.getTableModelListeners()) {
            TabInfoWithValidator.TabTableModelListener tabTableModelListener;
            if (!(tableModelListener instanceof TabInfoWithValidator.TabTableModelListener) || !tabEditors.contains((Object)(tabTableModelListener = (TabInfoWithValidator.TabTableModelListener)tableModelListener).getComponent())) continue;
            errorTableModel.removeTableModelListener(tableModelListener);
        }
    }
}

