/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageListModel;

public class SwingValidatorMessageListMouseListener
extends MouseAdapter {
    private static final Logger log = LogManager.getLogger(SwingValidatorMessageListMouseListener.class);

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2) {
            SwingValidatorMessage entry = this.getSelectedMessage(e);
            if (entry == null) {
                return;
            }
            JComponent component = entry.getEditor();
            if (component != null) {
                component.requestFocusInWindow();
            }
        }
    }

    protected SwingValidatorMessage getSelectedMessage(MouseEvent e) {
        JList list = (JList)e.getSource();
        if (!(list.getModel() instanceof SwingValidatorMessageListModel)) {
            if (log.isWarnEnabled()) {
                log.warn("model must be a " + SwingValidatorMessageListModel.class + ", but was " + list.getModel());
            }
            return null;
        }
        SwingValidatorMessageListModel model = (SwingValidatorMessageListModel)list.getModel();
        int index = list.getSelectionModel().getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        SwingValidatorMessage entry = (SwingValidatorMessage)((Object)model.getElementAt(index));
        if (log.isDebugEnabled()) {
            log.debug("selected index: " + index + " : error: " + entry);
        }
        return entry;
    }
}

