/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JTable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.swing.SwingListValidatorDataLocator;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableModel;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableModel;

public class SwingListValidatorMessageTableMouseListener
extends MouseAdapter {
    private static final Logger log = LogManager.getLogger(SwingListValidatorMessageTableMouseListener.class);
    public static final String HIGHLIGHT_ERROR_PROPERTY = "highlightError";
    protected final PropertyChangeSupport pcs;
    protected final JTable editor;
    protected final SwingListValidatorDataLocator dataLocator;

    public SwingListValidatorMessageTableMouseListener(JTable editor, SwingListValidatorDataLocator dataLocator) {
        this.editor = editor;
        this.dataLocator = dataLocator;
        this.pcs = new PropertyChangeSupport(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2) {
            SwingListValidatorMessage entry = this.getSelectedMessage(e);
            if (entry == null) {
                return;
            }
            if (this.dataLocator.acceptType(entry.getBean().getClass())) {
                Pair<Integer, Integer> cell = this.dataLocator.locateDataCell(this.editor.getModel(), entry.getBean(), entry.getField());
                SwingUtil.editCell((JTable)this.editor, (int)((Integer)cell.getLeft()), (int)((Integer)cell.getRight()));
            }
        }
    }

    protected SwingListValidatorMessage getSelectedMessage(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        if (!(table.getModel() instanceof SwingListValidatorMessageTableModel)) {
            if (log.isWarnEnabled()) {
                log.warn("model must be a " + SwingValidatorMessageTableModel.class + ", but was " + table.getModel());
            }
            return null;
        }
        SwingListValidatorMessageTableModel model = (SwingListValidatorMessageTableModel)table.getModel();
        int index = table.getSelectionModel().getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        if (table.getRowSorter() != null) {
            index = table.getRowSorter().convertRowIndexToModel(index);
        }
        SwingListValidatorMessage entry = model.getRow(index);
        if (log.isDebugEnabled()) {
            log.debug("selected index: " + index + " : error: " + (Object)((Object)entry));
        }
        return entry;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

