/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.ultreia.java4all.i18n.I18n;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.TableModelListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.util.ReflectUtil;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.SimpleBeanValidatorMessageTableRenderer;
import org.nuiton.jaxx.validator.swing.SwingListValidatorDataLocator;
import org.nuiton.jaxx.validator.swing.SwingListValidatorHighlightPredicate;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableModel;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableMouseListener;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableRenderer;
import org.nuiton.jaxx.validator.swing.SwingListValidatorTableEditorModelListener;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageListMouseListener;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableModel;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableMouseListener;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableRenderer;
import org.nuiton.jaxx.validator.swing.meta.Validator;
import org.nuiton.jaxx.validator.swing.meta.ValidatorField;
import org.nuiton.jaxx.validator.swing.tab.TabInfoWithValidator;
import org.nuiton.jaxx.validator.swing.unified.UnifiedValidatorMessage;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.list.BeanListValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorMessage;
import org.nuiton.validator.bean.simple.SimpleBeanValidators;

public class SwingValidatorUtil
extends SimpleBeanValidators {
    private static final Logger log = LogManager.getLogger(SwingValidatorUtil.class);
    protected static EnumMap<NuitonValidatorScope, ImageIcon> icons;
    protected static EnumMap<NuitonValidatorScope, Color> colors;

    public static EnumMap<NuitonValidatorScope, ImageIcon> getIcons() {
        if (icons == null) {
            icons = new EnumMap(NuitonValidatorScope.class);
            icons.put(NuitonValidatorScope.FATAL, SwingUtil.createImageIcon((String)"fatal.png"));
            icons.put(NuitonValidatorScope.ERROR, SwingUtil.createImageIcon((String)"error.png"));
            icons.put(NuitonValidatorScope.WARNING, SwingUtil.createImageIcon((String)"warning.png"));
            icons.put(NuitonValidatorScope.INFO, SwingUtil.createImageIcon((String)"info.png"));
        }
        return icons;
    }

    public static EnumMap<NuitonValidatorScope, Color> getColors() {
        if (colors == null) {
            colors = new EnumMap(NuitonValidatorScope.class);
            colors.put(NuitonValidatorScope.FATAL, Color.MAGENTA);
            colors.put(NuitonValidatorScope.ERROR, Color.RED);
            colors.put(NuitonValidatorScope.WARNING, Color.YELLOW);
            colors.put(NuitonValidatorScope.INFO, Color.GREEN);
        }
        return colors;
    }

    public static Color getColor(NuitonValidatorScope scope) {
        return scope == null ? null : SwingValidatorUtil.getColors().get(scope);
    }

    public static ImageIcon getIcon(NuitonValidatorScope scope) {
        return scope == null ? null : SwingValidatorUtil.getIcons().get(scope);
    }

    public static ImageIcon getFatalIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.FATAL);
    }

    public static ImageIcon getErrorIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.ERROR);
    }

    public static ImageIcon getWarningIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.WARNING);
    }

    public static ImageIcon getInfoIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.INFO);
    }

    protected SwingValidatorUtil() {
    }

    public static <O> SwingValidator<O> newValidator(Class<O> type, String context) {
        return SwingValidator.newValidator(type, context, new NuitonValidatorScope[0]);
    }

    public static void installUI(JAXXValidator ui) {
        ui.registerValidatorFields();
        List<String> validatorIds = ui.getValidatorIds();
        for (String validatorId : validatorIds) {
            SwingValidator<?> validator = ui.getValidator(validatorId);
            validator.installUIs();
            validator.reloadBean();
        }
    }

    public static List<String> detectValidators(JAXXValidator ui) {
        ArrayList<String> validatorIds = new ArrayList<String>();
        Map validators = ReflectUtil.getFieldAnnotation(ui.getClass(), Validator.class, (boolean)true);
        for (Map.Entry entry : validators.entrySet()) {
            Field field = (Field)entry.getKey();
            Validator annotation = (Validator)entry.getValue();
            String validatorId = annotation.validatorId();
            validatorIds.add(validatorId);
            if (!log.isInfoEnabled()) continue;
            log.info("Detect validator [" + annotation.validatorId() + "]  on field " + field.getName());
        }
        return Collections.unmodifiableList(validatorIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detectValidatorFields(JAXXValidator ui) {
        Multimap<JComponent, ValidatorField> editors = SwingValidatorUtil.getValidatorEditors(ui);
        try {
            for (String validatorId : ui.getValidatorIds()) {
                SwingValidator<?> validator = ui.getValidator(validatorId);
                for (Map.Entry entry : editors.entries()) {
                    String[] propertyNames;
                    ValidatorField fieldAnnotation = (ValidatorField)entry.getValue();
                    JComponent editor = (JComponent)entry.getKey();
                    if (!validatorId.equals(fieldAnnotation.validatorId())) continue;
                    for (String propertyName : propertyNames = fieldAnnotation.propertyName()) {
                        if (log.isInfoEnabled()) {
                            log.info("Detects for validator [" + validatorId + "] property " + propertyName + " for editor " + fieldAnnotation.editorName());
                        }
                        validator.setFieldRepresentation(propertyName, editor);
                    }
                }
            }
        }
        finally {
            editors.clear();
        }
    }

    public static void installUI(JTable errorTable, SwingValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer((JTable)errorTable, (String[])new String[]{I18n.n((String)"validator.scope.header", (Object[])new Object[0]), I18n.n((String)"validator.scope.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.field.header", (Object[])new Object[0]), I18n.n((String)"validator.field.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.message.header", (Object[])new Object[0]), I18n.n((String)"validator.message.header.tip", (Object[])new Object[0])});
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        SwingUtil.fixTableColumnWidth((JTable)errorTable, (int)0, (int)25);
    }

    public static void installUI(JTable errorTable, SimpleBeanValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer((JTable)errorTable, (String[])new String[]{I18n.n((String)"validator.scope.header", (Object[])new Object[0]), I18n.n((String)"validator.scope.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.field.header", (Object[])new Object[0]), I18n.n((String)"validator.field.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.message.header", (Object[])new Object[0]), I18n.n((String)"validator.message.header.tip", (Object[])new Object[0])});
        SwingUtil.fixTableColumnWidth((JTable)errorTable, (int)0, (int)25);
    }

    public static void installUI(JTable errorTable, SwingListValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer((JTable)errorTable, (String[])new String[]{I18n.n((String)"validator.scope.header", (Object[])new Object[0]), I18n.n((String)"validator.scope.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.bean.header", (Object[])new Object[0]), I18n.n((String)"validator.bean.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.field.header", (Object[])new Object[0]), I18n.n((String)"validator.field.header.tip", (Object[])new Object[0]), I18n.n((String)"validator.message.header", (Object[])new Object[0]), I18n.n((String)"validator.message.header.tip", (Object[])new Object[0])});
        SwingUtil.fixTableColumnWidth((JTable)errorTable, (int)0, (int)25);
    }

    public static void installTabUI(JAXXValidator ui, TabInfoWithValidator tab) {
        TabInfoWithValidator.TabTableModelListener listener = new TabInfoWithValidator.TabTableModelListener(tab);
        tab.getValidator().getErrorTableModel().addTableModelListener(listener);
    }

    public static void uninstallTabUI(Collection<TabInfoWithValidator> tabEditors, SwingValidatorMessageTableModel errorTableModel) {
        for (TableModelListener tableModelListener : errorTableModel.getTableModelListeners()) {
            TabInfoWithValidator.TabTableModelListener tabTableModelListener;
            if (!(tableModelListener instanceof TabInfoWithValidator.TabTableModelListener) || !tabEditors.contains((Object)(tabTableModelListener = (TabInfoWithValidator.TabTableModelListener)tableModelListener).getComponent())) continue;
            errorTableModel.removeTableModelListener(tableModelListener);
        }
    }

    public static <O> void registerListValidator(BeanListValidator<O> validator, SwingListValidatorMessageTableModel errorTableModel, JTable dataTable, JTable errorTable, SwingListValidatorDataLocator<O> dataLocator) {
        errorTableModel.registerValidator(validator);
        errorTable.addMouseListener(new SwingListValidatorMessageTableMouseListener(dataTable, dataLocator));
        dataTable.getModel().addTableModelListener(new SwingListValidatorTableEditorModelListener<O>(validator, dataLocator));
    }

    public static <O> void addHightLighterOnEditor(BeanListValidator<O> validator, JXTable editor, SwingListValidatorDataLocator<O> dataLocator, NuitonValidatorScope ... scopes) {
        for (NuitonValidatorScope scope : scopes) {
            SwingListValidatorHighlightPredicate<O> predicate = SwingListValidatorHighlightPredicate.newPredicate(scope, validator, dataLocator);
            ColorHighlighter highlighter = new ColorHighlighter(predicate);
            highlighter.setBackground(SwingValidatorUtil.getColor(scope));
            editor.addHighlighter((Highlighter)highlighter);
        }
    }

    public static SwingValidatorMessageListMouseListener registerErrorListMouseListener(JList list) {
        SwingValidatorMessageListMouseListener listener = SwingValidatorUtil.getErrorListMouseListener(list);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageListMouseListener();
        if (log.isDebugEnabled()) {
            log.debug(listener.toString());
        }
        list.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageTableMouseListener registerErrorTableMouseListener(JTable table) {
        SwingValidatorMessageTableMouseListener listener = SwingValidatorUtil.getErrorTableMouseListener(table);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageTableMouseListener();
        if (log.isDebugEnabled()) {
            log.debug(listener.toString());
        }
        table.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageListMouseListener getErrorListMouseListener(JList list) {
        if (list != null) {
            for (MouseListener listener : list.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageListMouseListener)) continue;
                return (SwingValidatorMessageListMouseListener)listener;
            }
        }
        return null;
    }

    public static SwingValidatorMessageTableMouseListener getErrorTableMouseListener(JTable table) {
        if (table != null) {
            for (MouseListener listener : table.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageTableMouseListener)) continue;
                return (SwingValidatorMessageTableMouseListener)listener;
            }
        }
        return null;
    }

    public static SwingValidatorMessageTableMouseListener getListErrorTableMouseListener(JTable table) {
        if (table != null) {
            for (MouseListener listener : table.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageTableMouseListener)) continue;
                return (SwingValidatorMessageTableMouseListener)listener;
            }
        }
        return null;
    }

    public static String getMessage(SwingValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getI18nError(text);
        }
        return text;
    }

    public static String getMessage(SimpleBeanValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getI18nError(text);
        }
        return text;
    }

    public static String getMessage(SwingListValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getI18nError(text);
        }
        return text;
    }

    public static String getMessage(UnifiedValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getI18nError(text);
        }
        return text;
    }

    public static String getFieldName(SwingValidatorMessage model, String value) {
        String text = null;
        JComponent editor = model.getEditor();
        if (editor != null) {
            text = (String)editor.getClientProperty("validatorLabel");
        }
        if (text == null) {
            text = value;
        }
        return text;
    }

    public static String getFieldName(SwingListValidatorMessage model, String value) {
        String text = null;
        JComponent editor = model.getEditor();
        if (editor != null) {
            text = (String)editor.getClientProperty("validatorLabel");
        }
        if (text == null) {
            text = value;
        }
        return text;
    }

    public static String getFieldName(UnifiedValidatorMessage model, String value) {
        return SwingValidatorUtil.getFieldName(model, value, null);
    }

    public static String getFieldName(UnifiedValidatorMessage model, String value, String valueFallBack) {
        String text = null;
        JComponent editor = model.getEditor();
        Object validatorLabel = null;
        if (editor != null) {
            validatorLabel = editor.getClientProperty("validatorLabel");
        }
        if (validatorLabel != null) {
            if (model.isSimpleValidator()) {
                text = (String)validatorLabel;
            } else {
                Map validatorLabelMap = (Map)validatorLabel;
                String field = model.getField();
                text = (String)validatorLabelMap.get(field);
            }
        }
        if (text == null && valueFallBack != null) {
            text = valueFallBack;
        }
        if (text == null) {
            text = value;
        }
        return text;
    }

    public static void listenValidatorContextNameAndRefreshFields(SwingValidator<?> validator, JAXXValidator ui) {
        PropertyChangeListener listener = evt -> {
            SwingValidator validator1 = (SwingValidator)((Object)((Object)evt.getSource()));
            if (log.isInfoEnabled()) {
                log.info("Context name changed to [" + evt.getNewValue() + "] for validator " + validator1.getType());
            }
            ui.registerValidatorFields();
        };
        validator.addPropertyChangeListener("context", listener);
    }

    public static void setValidatorBean(JAXXObject ui, Object bean, String ... excludeIds) {
        if (!JAXXValidator.class.isAssignableFrom(ui.getClass())) {
            return;
        }
        JAXXValidator jaxxValidator = (JAXXValidator)ui;
        List<String> validatorIds = jaxxValidator.getValidatorIds();
        if (excludeIds.length > 0) {
            validatorIds = new ArrayList<String>(validatorIds);
            for (String excludeId : excludeIds) {
                validatorIds.remove(excludeId);
            }
        }
        for (String validatorId : validatorIds) {
            SwingValidator<?> beanValidator = jaxxValidator.getValidator(validatorId);
            if (bean != null && !beanValidator.getType().isAssignableFrom(bean.getClass())) continue;
            beanValidator.setBean(bean);
        }
    }

    public static void setValidatorChanged(JAXXObject ui, boolean newValue, String ... excludeIds) {
        if (!JAXXValidator.class.isAssignableFrom(ui.getClass())) {
            return;
        }
        JAXXValidator jaxxValidator = (JAXXValidator)ui;
        List<String> validatorIds = jaxxValidator.getValidatorIds();
        if (excludeIds.length > 0) {
            validatorIds = new ArrayList<String>(validatorIds);
            for (String excludeId : excludeIds) {
                validatorIds.remove(excludeId);
            }
        }
        for (String validatorId : validatorIds) {
            SwingValidator<?> beanValidator = jaxxValidator.getValidator(validatorId);
            beanValidator.setChanged(newValue);
        }
    }

    protected static Multimap<JComponent, ValidatorField> getValidatorEditors(JAXXValidator ui) {
        ArrayListMultimap editors = ArrayListMultimap.create();
        Map validatorFields = null;
        Map validatorMethods = null;
        try {
            JComponent editor;
            ValidatorField fieldAnnotation;
            validatorFields = ReflectUtil.getFieldAnnotation(ui.getClass(), ValidatorField.class, (boolean)true);
            validatorMethods = ReflectUtil.getMethodAnnotation(ui.getClass(), ValidatorField.class, (boolean)true);
            for (Map.Entry fieldEntry : validatorFields.entrySet()) {
                Field field = (Field)fieldEntry.getKey();
                field.setAccessible(true);
                fieldAnnotation = (ValidatorField)fieldEntry.getValue();
                editor = (JComponent)field.get(ui);
                editors.put((Object)editor, (Object)fieldAnnotation);
            }
            for (Map.Entry fieldEntry : validatorMethods.entrySet()) {
                Method method = (Method)fieldEntry.getKey();
                method.setAccessible(true);
                fieldAnnotation = (ValidatorField)fieldEntry.getValue();
                editor = (JComponent)method.invoke((Object)ui, new Object[0]);
                editors.put((Object)editor, (Object)fieldAnnotation);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init validators on ui " + ui, e);
        }
        finally {
            if (validatorFields != null) {
                validatorFields.clear();
            }
            if (validatorMethods != null) {
                validatorMethods.clear();
            }
        }
        return editors;
    }
}

