/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing.ui;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorEvent;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorListener;

public abstract class AbstractBeanValidatorUI
extends AbstractLayerUI<JComponent>
implements SimpleBeanValidatorListener {
    private static final Logger log = LogManager.getLogger(AbstractBeanValidatorUI.class);
    private static final long serialVersionUID = 1L;
    protected NuitonValidatorScope scope;
    protected final Set<String> fields;

    protected AbstractBeanValidatorUI(String field) {
        this(Sets.newHashSet((Object[])new String[]{field}));
    }

    protected AbstractBeanValidatorUI(Collection<String> fields) {
        this.fields = Sets.newHashSet(fields);
        if (log.isDebugEnabled()) {
            log.debug("install " + this + "<fields:" + this.fields + ">");
        }
    }

    public NuitonValidatorScope getScope() {
        return this.scope;
    }

    public void onFieldChanged(SimpleBeanValidatorEvent event) {
        if (this.fields.contains(event.getField())) {
            this.scope = this.getHighestScope(event);
            if (log.isDebugEnabled()) {
                log.debug("set new scope : " + this.scope + " to field " + this.fields);
            }
            this.setDirty(true);
        }
    }

    protected NuitonValidatorScope getHighestScope(SimpleBeanValidatorEvent event) {
        SimpleBeanValidator source = (SimpleBeanValidator)event.getSource();
        HashSet scopes = Sets.newHashSet();
        for (String field : this.fields) {
            NuitonValidatorScope scope = source.getHighestScope(field);
            if (scope == null) continue;
            scopes.add(scope);
        }
        return scopes.isEmpty() ? null : (NuitonValidatorScope)Ordering.natural().max((Iterable)scopes);
    }
}

