/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import io.ultreia.java4all.i18n.I18n;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.nuiton.jaxx.validator.swing.SimpleBeanValidatorMessageTableModel;
import org.nuiton.jaxx.validator.swing.SwingValidatorUtil;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorMessage;

public class SimpleBeanValidatorMessageTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel rendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ImageIcon icon = null;
        String text = null;
        String toolTipText = null;
        column = table.convertColumnIndexToModel(column);
        if (table.getRowSorter() != null) {
            row = table.getRowSorter().convertRowIndexToModel(row);
        }
        switch (column) {
            case 0: {
                NuitonValidatorScope scope = (NuitonValidatorScope)value;
                icon = SwingValidatorUtil.getIcon(scope);
                String label = I18n.t((String)scope.getLabel(), (Object[])new Object[0]);
                toolTipText = I18n.t((String)"validator.scope.tip", (Object[])new Object[]{label});
                break;
            }
            case 1: {
                text = this.getFieldName(table, (String)value, row);
                toolTipText = I18n.t((String)"validator.field.tip", (Object[])new Object[]{text});
                break;
            }
            case 2: {
                text = this.getMessage(table, (String)value, row);
                toolTipText = I18n.t((String)"validator.message.tip", (Object[])new Object[]{text});
            }
        }
        rendererComponent.setText(text);
        rendererComponent.setToolTipText(toolTipText);
        rendererComponent.setIcon(icon);
        return rendererComponent;
    }

    public ImageIcon getIcon(NuitonValidatorScope scope) {
        return SwingValidatorUtil.getIcon(scope);
    }

    public String getMessage(JTable table, String value, int row) {
        SimpleBeanValidatorMessageTableModel tableModel = (SimpleBeanValidatorMessageTableModel)table.getModel();
        SimpleBeanValidatorMessage model = tableModel.getRow(row);
        return SwingValidatorUtil.getMessage(model);
    }

    public String getFieldName(JTable table, String value, int row) {
        SimpleBeanValidatorMessageTableModel tableModel = (SimpleBeanValidatorMessageTableModel)table.getModel();
        return value;
    }
}

