/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.Base64Coder;
import org.nuiton.jaxx.runtime.DataBindingListener;
import org.nuiton.jaxx.runtime.DataBindingUpdateListener;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.context.JAXXContextEntryDef;
import org.nuiton.jaxx.runtime.context.JAXXInitialContext;

public class JAXXUtil {
    private static final Logger log = LogManager.getLogger(JAXXUtil.class);
    public static final String PARENT = "parent";
    private static final Map<Object, WeakReference<List<EventListenerDescriptor>>> eventListeners = new WeakHashMap<Object, WeakReference<List<EventListenerDescriptor>>>();
    private static final Map<JAXXObject, WeakReference<List<DataBindingUpdateListener>>> dataBindingUpdateListeners = new WeakHashMap<JAXXObject, WeakReference<List<DataBindingUpdateListener>>>();
    private static final PropertyChangeListener[] EMPTY_ARRAY_PROPERTY_CHANGE_LISTENERS = new PropertyChangeListener[0];

    public static JAXXObjectDescriptor decodeJAXXObjectDescriptor(String descriptor) {
        try {
            return (JAXXObjectDescriptor)Base64Coder.deserialize(descriptor, false);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    public static JAXXObjectDescriptor decodeCompressedJAXXObjectDescriptor(String descriptor) {
        try {
            return (JAXXObjectDescriptor)Base64Coder.deserialize(descriptor, true);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    public static <O> JAXXContextEntryDef<O> newContextEntryDef(Class<O> klass) {
        return JAXXUtil.newContextEntryDef(null, klass);
    }

    public static <O> JAXXContextEntryDef<O> newContextEntryDef(String name, Class<?> klass) {
        return new JAXXContextEntryDef(name, klass);
    }

    public static <O> JAXXContextEntryDef<List<O>> newListContextEntryDef() {
        return JAXXUtil.newListContextEntryDef(null);
    }

    public static <O> JAXXContextEntryDef<List<O>> newListContextEntryDef(String name) {
        Class<List<O>> castList = JAXXUtil.castList();
        return new JAXXContextEntryDef<List<O>>(name, castList);
    }

    public static <K, V> JAXXContextEntryDef<Map<K, V>> newMapContextEntryDef(String name) {
        return new JAXXContextEntryDef<Map<K, V>>(Map.class, name);
    }

    protected static <K, V> Class<Map<K, V>> castMap() {
        return Collections.emptyMap().getClass();
    }

    protected static <O> Class<List<O>> castList() {
        return List.of().getClass();
    }

    public static void initContext(JAXXObject ui, JAXXContext parentContext) {
        if (parentContext instanceof JAXXInitialContext) {
            ((JAXXInitialContext)parentContext).to((JAXXContext)ui);
        } else {
            ui.setContextValue((Object)parentContext);
        }
        if (parentContext instanceof JAXXObject) {
            ui.setContextValue((Object)parentContext, PARENT);
        }
    }

    public static <E extends EventListener> E getEventListener(Class<E> listenerClass, String listenerMethodName, Object methodContainer, String methodName) {
        ArrayList<EventListenerDescriptor> descriptors;
        WeakReference<List<EventListenerDescriptor>> ref = eventListeners.get(methodContainer);
        ArrayList<EventListenerDescriptor> arrayList = descriptors = ref != null ? (ArrayList<EventListenerDescriptor>)ref.get() : null;
        if (descriptors == null) {
            descriptors = new ArrayList<EventListenerDescriptor>();
            eventListeners.put(methodContainer, new WeakReference(descriptors));
        } else {
            for (EventListenerDescriptor descriptor : descriptors) {
                if (!descriptor.listenerClass.equals(listenerClass) || !(listenerMethodName == null ? descriptor.listenerMethodName == null : listenerMethodName.equals(descriptor.listenerMethodName)) || !methodName.equals(descriptor.methodName)) continue;
                return (E)((EventListener)descriptor.eventListener);
            }
        }
        EventListenerDescriptor descriptor = new EventListenerDescriptor();
        descriptor.listenerClass = listenerClass;
        descriptor.listenerMethodName = listenerMethodName;
        descriptor.methodName = methodName;
        try {
            List<Method> listenerMethods = Arrays.asList(listenerClass.getMethods());
            Method listenerMethod = null;
            if (listenerMethodName != null) {
                for (Method listenerMethod1 : listenerMethods) {
                    if (!listenerMethod1.getName().equals(listenerMethodName)) continue;
                    listenerMethod = listenerMethod1;
                    break;
                }
            }
            if (listenerMethodName != null && listenerMethod == null) {
                throw new IllegalArgumentException("no method named " + listenerMethodName + " found in class " + listenerClass.getName());
            }
            Class<?>[] parameterTypes = listenerMethodName != null ? listenerMethod.getParameterTypes() : listenerMethods.get(0).getParameterTypes();
            Class<?> methodContainerClass = methodContainer.getClass();
            Method targetMethod = methodContainerClass.getMethod(methodName, parameterTypes);
            descriptor.eventListener = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (proxy, method, args) -> {
                String methodName1 = method.getName();
                if (listenerMethodName == null && listenerMethods.contains(method) || methodName1.equals(listenerMethodName)) {
                    try {
                        targetMethod.setAccessible(true);
                        return targetMethod.invoke(methodContainer, args);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("could not invoke on container " + methodContainer, e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (methodName1.equals("toString")) {
                    return descriptor.toString();
                }
                if (methodName1.equals("equals")) {
                    return descriptor.eventListener == args[0];
                }
                if (methodName1.equals("hashCode")) {
                    return descriptor.hashCode();
                }
                return null;
            });
            descriptors.add(descriptor);
            return (E)((EventListener)descriptor.eventListener);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <E extends EventListener> E getEventListener(Class<E> listenerClass, Object methodContainer, String methodName) {
        return JAXXUtil.getEventListener(listenerClass, null, methodContainer, methodName);
    }

    public static DataBindingUpdateListener getDataBindingUpdateListener(JAXXObject object, String bindingName) {
        ArrayList<DataBindingUpdateListener> listeners;
        WeakReference<List<DataBindingUpdateListener>> ref = dataBindingUpdateListeners.get(object);
        ArrayList<DataBindingUpdateListener> arrayList = listeners = ref == null ? null : (ArrayList<DataBindingUpdateListener>)ref.get();
        if (listeners == null) {
            listeners = new ArrayList<DataBindingUpdateListener>();
            dataBindingUpdateListeners.put(object, new WeakReference(listeners));
        } else {
            for (DataBindingUpdateListener listener : listeners) {
                if (!bindingName.equals(listener.getBindingName())) continue;
                return listener;
            }
        }
        DataBindingUpdateListener listener = new DataBindingUpdateListener(object, bindingName);
        listeners.add(listener);
        return listener;
    }

    public static void destroy(PropertyChangeSupport pcs) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener l : listeners = pcs.getPropertyChangeListeners()) {
            if (log.isInfoEnabled()) {
                if (l instanceof PropertyChangeListenerProxy) {
                    PropertyChangeListenerProxy ll = (PropertyChangeListenerProxy)l;
                    log.info("remove property change listener " + ll.getPropertyName() + " : " + l);
                } else {
                    log.info("remove property change listener " + l);
                }
            }
            pcs.removePropertyChangeListener(l);
        }
    }

    public static void destroy(Component component) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener l : listeners = component.getPropertyChangeListeners()) {
            if (log.isInfoEnabled()) {
                if (l instanceof PropertyChangeListenerProxy) {
                    PropertyChangeListenerProxy ll = (PropertyChangeListenerProxy)l;
                    log.info("remove property change listener " + ll.getPropertyName() + " : " + l);
                } else {
                    log.info("remove property change listener " + l);
                }
            }
            component.removePropertyChangeListener(l);
        }
    }

    public static String getStringValue(Object value) {
        String result = value == null ? "" : value.toString();
        return result;
    }

    public static void checkJAXXContextEntries(JAXXContext context, JAXXContextEntryDef<?> ... defs) throws IllegalArgumentException {
        for (JAXXContextEntryDef<?> def : defs) {
            Object value = def.getContextValue(context);
            if (value != null) continue;
            throw new IllegalArgumentException("the context entry [" + def + "] ] was not found in context " + context);
        }
    }

    public static <T> T checkJAXXContextEntry(JAXXContext context, JAXXContextEntryDef<T> def) throws IllegalArgumentException {
        T value = def.getContextValue(context);
        if (value == null) {
            throw new IllegalArgumentException("the context entry [" + def + "] ] was not found in context " + context);
        }
        return value;
    }

    public static void reloadBinding(JAXXBinding binding) {
        binding.removeDataBinding();
        binding.applyDataBinding();
    }

    public static void reloadBinding(JAXXObject src, String bindingId) {
        JAXXBinding dataBinding = src.getDataBinding(bindingId);
        if (dataBinding != null) {
            JAXXUtil.reloadBinding(dataBinding);
        } else if (log.isWarnEnabled()) {
            log.warn("Could not found binding[" + bindingId + "] on ui " + src);
        }
    }

    public static void applyDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.applyDataBinding(binding);
        }
    }

    public static void applyDataBinding(JAXXObject src, Collection<String> bindings) {
        for (String binding : bindings) {
            src.applyDataBinding(binding);
        }
    }

    public static void processDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.processDataBinding(binding);
        }
    }

    public static void removeDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.removeDataBinding(binding);
        }
    }

    public static void removeAllDataBindings(JAXXObject src) {
        JAXXBinding[] bindings;
        for (JAXXBinding binding : bindings = src.getDataBindings()) {
            JAXXUtil.removeDataBinding(src, binding.getId());
        }
    }

    public static PropertyChangeListener[] findJaxxPropertyChangeListener(String[] propertyNames, PropertyChangeListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            return EMPTY_ARRAY_PROPERTY_CHANGE_LISTENERS;
        }
        List<String> pNames = Arrays.asList(propertyNames);
        ArrayList<PropertyChangeListenerProxy> toRemove = new ArrayList<PropertyChangeListenerProxy>();
        for (PropertyChangeListener listener : listeners) {
            String pName = null;
            PropertyChangeListenerProxy plistener = null;
            if (listener instanceof PropertyChangeListenerProxy) {
                plistener = (PropertyChangeListenerProxy)listener;
                if (!pNames.contains(plistener.getPropertyName())) continue;
                listener = (PropertyChangeListener)plistener.getListener();
                pName = plistener.getPropertyName();
            }
            if (plistener == null || pName == null || !(listener instanceof DataBindingListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug("find config listener to remove  [" + pName + "] : " + listener);
            }
            toRemove.add(plistener);
        }
        return toRemove.toArray(new PropertyChangeListener[toRemove.size()]);
    }

    public static <O> O invokeConstructor(Class<O> type, Class<?>[] prototype, Object ... parms) throws Exception {
        return (O)ConstructorUtils.invokeConstructor(type, (Object[])parms, (Class[])prototype);
    }

    public static void copyToClipBoard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (log.isInfoEnabled()) {
            log.info("Put in clipboard :\n" + text);
        }
        StringSelection selection = new StringSelection(text);
        clipboard.setContents(selection, selection);
    }

    private static class EventListenerDescriptor {
        Class<?> listenerClass;
        String listenerMethodName;
        String methodName;
        Object eventListener;

        private EventListenerDescriptor() {
        }
    }
}

