/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.wizard;

import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.BlockingLayerUI;

public class BusyChangeListener
implements PropertyChangeListener {
    private static final Logger log = LogManager.getLogger(BusyChangeListener.class);
    protected Cursor busyCursor;
    protected Cursor defaultCursor;
    protected final Component ui;
    protected BlockingLayerUI blockingUI;

    public BusyChangeListener(Component ui) {
        this.ui = ui;
    }

    public Component getUi() {
        return this.ui;
    }

    public BlockingLayerUI getBlockingUI() {
        return this.blockingUI;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Boolean value = (Boolean)evt.getNewValue();
        if (log.isDebugEnabled()) {
            log.debug("busy state changed to " + value);
        }
        if (value != null && value.booleanValue()) {
            this.setBusy(this.ui);
        } else {
            this.setUnBusy(this.ui);
        }
    }

    public void setBlockingUI(BlockingLayerUI blockingUI) {
        this.blockingUI = blockingUI;
    }

    protected void setBusy(Component ui) {
        if (ui != null) {
            ui.setCursor(this.getBusyCursor());
        }
        if (this.blockingUI != null) {
            this.blockingUI.setBlock(true);
        }
    }

    protected void setUnBusy(Component ui) {
        if (ui != null) {
            ui.setCursor(this.getDefaultCursor());
        }
        if (this.blockingUI != null) {
            this.blockingUI.setBlock(false);
        }
    }

    protected Cursor getBusyCursor() {
        if (this.busyCursor == null) {
            this.busyCursor = Cursor.getPredefinedCursor(3);
        }
        return this.busyCursor;
    }

    protected Cursor getDefaultCursor() {
        if (this.defaultCursor == null) {
            this.defaultCursor = Cursor.getDefaultCursor();
        }
        return this.defaultCursor;
    }
}

