/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.application;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.application.ActionWorker;
import org.nuiton.jaxx.runtime.swing.application.event.ActionExecutorEvent;
import org.nuiton.jaxx.runtime.swing.application.event.ActionExecutorListener;
import org.nuiton.jaxx.runtime.util.ReflectUtil;

public class ActionExecutor {
    private static final Logger log = LogManager.getLogger(ActionExecutor.class);
    protected final Set<ActionWorker<?, ?>> tasks = new HashSet();
    protected final PropertyChangeListener workerListener;
    private final transient EventListenerList listenerList = new EventListenerList();

    public ActionExecutor() {
        this.workerListener = evt -> {
            log.debug(String.format("action %s property %s changed <%s - %s>", evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
            if (!"state".equals(evt.getPropertyName())) return;
            ActionWorker source = (ActionWorker)evt.getSource();
            SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)((Object)evt.getNewValue()));
            if (state == SwingWorker.StateValue.STARTED) {
                this.onActionStart(source);
                return;
            }
            if (state != SwingWorker.StateValue.DONE) return;
            ActionWorker.ActionStatus status = source.getStatus();
            log.debug(String.format("Action [%s] status = %s", new Object[]{source.getActionLabel(), status}));
            try {
                switch (status) {
                    case OK: {
                        this.onActionEnd(source);
                        return;
                    }
                    case CANCEL: {
                        this.onActionCancel(source);
                        return;
                    }
                    case FAIL: {
                        this.onActionFail(source);
                        return;
                    }
                }
                return;
            }
            finally {
                this.tasks.remove(source);
                this.onAfterAction(source);
            }
        };
    }

    public ActionWorker<?, ?> addAction(String actionLabel, Runnable action) {
        ActionWorker worker = action instanceof ActionWorker ? (ActionWorker)action : new ActionWorker(actionLabel, action);
        worker.addPropertyChangeListener(this.workerListener);
        this.tasks.add(worker);
        this.executeWorker(actionLabel, worker);
        return worker;
    }

    public void addAction(ActionWorker<?, ?> worker) {
        this.addAction(worker.getActionLabel(), worker);
    }

    public void onActionStart(ActionWorker<?, ?> source) {
        this.fireActionStart(source);
    }

    public void onActionFail(ActionWorker<?, ?> source) {
        this.fireActionFail(source);
    }

    public void onActionCancel(ActionWorker<?, ?> source) {
        this.fireActionCancel(source);
    }

    public void onActionEnd(ActionWorker<?, ?> source) {
        this.fireActionEnd(source);
    }

    public void onAfterAction(ActionWorker<?, ?> source) {
        this.fireActionDone(source);
    }

    public void terminatesAndWaits() {
        log.debug(String.format("Executor %s is terminating...", this));
        for (ActionWorker<?, ?> task : this.tasks) {
            task.cancel(true);
        }
        log.debug(String.format("Executor %s was terminated at %s", this, new Date()));
    }

    public void addActionExecutorListener(ActionExecutorListener listener) {
        log.info(String.format("adding listener %s", listener));
        this.listenerList.add(ActionExecutorListener.class, listener);
    }

    public void removeActionExecutorListener(ActionExecutorListener listener) {
        log.info(String.format("removing listener %s", listener));
        this.listenerList.remove(ActionExecutorListener.class, listener);
    }

    protected ActionExecutorListener[] getActionExecutorListener() {
        return (ActionExecutorListener[])this.listenerList.getListeners(ActionExecutorListener.class);
    }

    protected void fireActionStart(ActionWorker<?, ?> source) {
        this.fireAction(source, ActionExecutorListener::actionStart);
    }

    protected void fireActionFail(ActionWorker<?, ?> source) {
        this.fireAction(source, ActionExecutorListener::actionFail);
    }

    protected void fireActionCancel(ActionWorker<?, ?> source) {
        this.fireAction(source, ActionExecutorListener::actionCancel);
    }

    protected void fireActionEnd(ActionWorker<?, ?> source) {
        this.fireAction(source, ActionExecutorListener::actionEnd);
    }

    protected void fireActionDone(ActionWorker<?, ?> worker) {
        this.fireAction(worker, ActionExecutorListener::actionDone);
    }

    protected void fireAction(ActionWorker<?, ?> worker, BiConsumer<ActionExecutorListener, ActionExecutorEvent> function) {
        ActionExecutorEvent evt = new ActionExecutorEvent(this, worker);
        for (ActionExecutorListener listener : this.getActionExecutorListener()) {
            function.accept(listener, evt);
            if (evt.isConsumed()) break;
        }
    }

    public int getNbActions() {
        return this.getTasks().size();
    }

    public Set<ActionWorker<?, ?>> getTasks() {
        return this.tasks;
    }

    public Runnable createRunnable(Object methodContainer, String methodName, Object ... arguments) {
        Class<?> klass = methodContainer.getClass();
        Method targetMethod = ReflectUtil.getDeclaredMethod(klass, methodName, true, arguments);
        targetMethod.setAccessible(true);
        Runnable result = (Runnable)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Runnable.class}, (proxy, method, args) -> {
            String methodName1 = method.getName();
            if ("run".equals(methodName1)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("will invoke run method");
                    }
                    return targetMethod.invoke(methodContainer, arguments);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("could not invoke on container " + methodContainer, e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (methodName1.equals("toString")) {
                return this.toString();
            }
            if (methodName1.equals("equals")) {
                return this.equals(args[0]);
            }
            if (methodName1.equals("hashCode")) {
                return this.hashCode();
            }
            return null;
        });
        return result;
    }

    protected void executeWorker(String actionLabel, ActionWorker<?, ?> worker) {
        worker.execute();
    }
}

