/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application;

import io.ultreia.java4all.config.ConfigOptionDef;
import io.ultreia.java4all.util.SortedProperties;
import io.ultreia.java4all.util.Zips;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.application.ApplicationConfiguration;

public class ApplicationResourceManager {
    private static final Logger log = LogManager.getLogger(ApplicationResourceManager.class);
    private final Map<String, Resource> resourceDefinitions = new TreeMap<String, Resource>();
    private Map<String, Properties> resources;

    public static URL getResource(String location) {
        URL resource = ApplicationResourceManager.class.getResource(location);
        try {
            try (InputStream in = ApplicationResourceManager.openInternalStream(resource);){
                log.debug("opening: " + in);
            }
            return resource;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not treat internal resource " + location);
        }
    }

    protected static InputStream openInternalStream(URL resource) {
        try {
            InputStream in = resource.openStream();
            Objects.requireNonNull(in, "Could not find internal resource " + resource);
            return in;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not treat internal resource " + resource);
        }
    }

    public void registerResource(Resource resource) {
        this.resourceDefinitions.put(resource.getLocation(), resource);
    }

    protected Map<String, Properties> getResources() {
        if (this.resources == null) {
            this.resources = new TreeMap<String, Properties>();
        }
        return this.resources;
    }

    public Properties getResourceProperties(String resource) throws IOException {
        URL url = this.getRegistredResource(resource).getUrl();
        return this.getResource(url);
    }

    private Properties getResource(URL url) throws IOException {
        String path = url.toString();
        Properties result = this.getResources().get(path);
        if (result == null) {
            result = this.load(url);
            log.debug("Store configuration [" + path + "]");
            this.getResources().put(path, result);
        }
        SortedProperties tmp = new SortedProperties();
        tmp.putAll((Map)result);
        return tmp;
    }

    public Properties load(URL url) throws IOException {
        Properties result;
        try (InputStream in = ApplicationResourceManager.openInternalStream(url);){
            result = new Properties();
            result.load(in);
        }
        return result;
    }

    public void copyResource(String resource, File file, String message) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            try (InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(ApplicationResourceManager.openInternalStream(this.getRegistredResource(resource).getUrl())), StandardCharsets.UTF_8);){
                IOUtils.copy((Reader)in, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
            }
            log.debug(message);
        }
    }

    private Resource getRegistredResource(String resource) {
        return Objects.requireNonNull(this.resourceDefinitions.get(resource));
    }

    public void copyResource(URL resource, File file, String message) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            try (InputStream in = ApplicationResourceManager.openInternalStream(resource);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            log.debug(message);
        }
    }

    public File createDirectory(ApplicationConfiguration config, ConfigOptionDef option) throws IOException {
        File dir = config.get().getOptionAsFile(option.getKey());
        this.createDirectory(dir);
        return dir;
    }

    public void createParentDirectory(ApplicationConfiguration config, ConfigOptionDef ... options) throws IOException {
        for (ConfigOptionDef option : options) {
            File dir = config.get().getOptionAsFile(option.getKey()).getParentFile();
            this.createDirectory(dir);
        }
    }

    protected File createDirectory(File dir) throws IOException {
        if (!dir.exists()) {
            log.debug(String.format("Create directory %s", dir));
            log.debug(String.format("Directory %s exists.", dir));
            boolean b = dir.mkdirs();
            if (!b) {
                throw new IOException(String.format("Can not create directory: %s", dir));
            }
        }
        return dir;
    }

    public void unzipToDirectory(String resourceName, ApplicationConfiguration config, ConfigOptionDef option) throws IOException {
        File dir = config.get().getOptionAsFile(option.getKey());
        this.createDirectory(dir);
        URL resourceUrl = this.getResourceUrl(resourceName);
        try (InputStream inputStream = ApplicationResourceManager.openInternalStream(resourceUrl);){
            Zips.uncompress((InputStream)inputStream, (File)dir);
        }
    }

    public URL getResourceUrl(String resource) {
        return this.getRegistredResource(resource).getUrl();
    }

    public String getResourceFilename(String resource) {
        return this.getRegistredResource(resource).getFilename();
    }

    public static class ClassPathResource
    implements Resource {
        private final String location;
        private URL url;

        public ClassPathResource(String location) {
            this.location = location;
        }

        @Override
        public String getLocation() {
            return this.location;
        }

        @Override
        public URL getUrl() {
            if (this.url == null) {
                this.url = ApplicationResourceManager.getResource(this.location);
            }
            return this.url;
        }

        @Override
        public boolean exists(File directory) {
            File file = this.getFile(directory);
            return file.exists();
        }

        @Override
        public File getFile(File directory) {
            return new File(directory, this.getFilename());
        }

        @Override
        public String getFilename() {
            return this.location.substring(1);
        }
    }

    public static interface Resource {
        public URL getUrl();

        public boolean exists(File var1);

        public File getFile(File var1);

        public String getFilename();

        public String getLocation();
    }
}

