/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application.action;

import io.ultreia.java4all.lang.Strings;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionWorker<R, P>
extends SwingWorker<R, P> {
    private static final Logger log = LogManager.getLogger(ActionWorker.class);
    protected final String actionLabel;
    protected Callable<R> target;
    protected ActionStatus status;
    protected Exception error;
    protected long startTime;
    protected long endTime;

    public ActionWorker(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public ActionWorker(String actionLabel, Runnable target) {
        this.target = new RunnableBridge(target);
        this.actionLabel = actionLabel;
    }

    public Callable<R> getTarget() {
        return this.target;
    }

    public void setTarget(Callable<R> target) {
        this.target = target;
    }

    public void setTarget(Runnable target) {
        this.setTarget(new RunnableBridge(target));
    }

    @Override
    protected R doInBackground() {
        Objects.requireNonNull(this.target, "Target field can not be null here.");
        this.startTime = System.nanoTime();
        log.debug("Action [" + this.getActionLabel() + "] is starting...");
        R result = null;
        try {
            result = this.getTarget().call();
        }
        catch (Exception e) {
            this.error = e;
        }
        finally {
            log.debug("Action [" + this.getActionLabel() + "] is ending...");
        }
        return result;
    }

    public boolean isFailed() {
        return (this.isDone() || this.isCancelled()) && this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public ActionStatus getStatus() {
        return this.status;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    @Override
    protected void done() {
        super.done();
        this.endTime = System.nanoTime();
        this.status = this.error != null ? ActionStatus.FAIL : (this.isCancelled() ? ActionStatus.CANCEL : ActionStatus.OK);
        if (log.isDebugEnabled()) {
            log.debug("Action [" + this.getActionLabel() + "] ends with status : " + this.status + " in " + this.getTime());
        }
    }

    public String getTime() {
        return Strings.convertTime((long)(this.endTime - this.startTime));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private static class RunnableBridge<R>
    implements Callable<R> {
        private final Runnable target;

        public RunnableBridge(Runnable target) {
            this.target = target;
        }

        @Override
        public R call() {
            this.target.run();
            return null;
        }
    }

    public static enum ActionStatus {
        OK,
        CANCEL,
        FAIL;

    }
}

