/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.i18n.runtime.I18nConfiguration;
import io.ultreia.java4all.i18n.runtime.I18nLanguageProvider;
import io.ultreia.java4all.i18n.runtime.boot.DefaultI18nBootLoader;
import io.ultreia.java4all.i18n.runtime.boot.I18nBootLoader;
import io.ultreia.java4all.i18n.runtime.boot.UserI18nBootLoader;
import io.ultreia.java4all.lang.Strings;
import io.ultreia.java4all.util.Zips;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.nuiton.jaxx.runtime.application.ApplicationBoot;
import org.nuiton.jaxx.runtime.application.ApplicationBootInitializer;
import org.nuiton.jaxx.runtime.application.ApplicationBootInitializerException;
import org.nuiton.jaxx.runtime.application.ApplicationConfiguration;
import org.nuiton.jaxx.runtime.application.ApplicationContext;
import org.nuiton.jaxx.runtime.application.ApplicationContextComponent;
import org.nuiton.jaxx.runtime.application.ApplicationResourceManager;
import org.nuiton.jaxx.runtime.application.ModuleInitializer;
import org.nuiton.jaxx.runtime.application.action.ActionExecutor;
import org.nuiton.jaxx.runtime.application.action.event.WizardActionWorkerExecutorListener;
import org.nuiton.jaxx.runtime.resources.UIResourcesProviders;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public abstract class ApplicationBootInitializerSupport<Config extends ApplicationConfiguration, Context extends ApplicationContext<Config, Context>>
implements ApplicationBootInitializer<Config, Context> {
    private static final String I18N_ARCHIVE = "/i18n.zip";
    private final String[] args;
    private final ImmutableList<ModuleInitializer> modules;
    private final ApplicationResourceManager resourceManager;
    private String LOG_CONFIGURATION_FILE = "/${application.id}-log4j.properties";
    private Logger log = LogManager.getLogger(ApplicationBootInitializerSupport.class);

    protected ApplicationBootInitializerSupport(String ... args) {
        this.log.info(String.format("%s Create boot at %s with arguments: %s (%s)", ApplicationBoot.BOOT_LOG_PREFIX, new Date(), Arrays.toString(args), this));
        this.args = args;
        this.modules = ModuleInitializer.loadInitializer();
        this.resourceManager = new ApplicationResourceManager();
    }

    @Override
    public final String[] getArgs() {
        return this.args;
    }

    @Override
    public boolean haltOnExit() {
        return true;
    }

    @Override
    public final ActionExecutor createExecutor(ApplicationBoot<Config, Context> boot, Config configuration, Context context) {
        this.log.info(String.format("%s Create executor (boot %s, configuration: %s, context: %s)", ApplicationBoot.BOOT_LOG_PREFIX, boot, configuration, context));
        ActionExecutor executor = new ActionExecutor(boot, (ApplicationContext)context);
        executor.addActionExecutorListener(new WizardActionWorkerExecutorListener());
        return executor;
    }

    @Override
    public final void start(Config config, Context context) {
        this.log.info(String.format("%s Start application (version: %s) at %s (arguments: %s)", ApplicationBoot.BOOT_LOG_PREFIX, config.getApplicationVersion(), new Date(), Arrays.toString(this.args)));
        try {
            config.get().doAction(0);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Can't execute command line actions", e);
        }
    }

    @Override
    public final void initOnce() throws ApplicationBootInitializerException {
        this.modules.forEach(ModuleInitializer::init);
    }

    @Override
    public final void close() {
        this.modules.forEach(ModuleInitializer::close);
    }

    @Override
    public final void init(Config config, Context context) throws ApplicationBootInitializerException {
        this.log.info(String.format("%s init application at %s (arguments: %s).", ApplicationBoot.BOOT_LOG_PREFIX, new Date(), Arrays.toString(this.getArgs())));
        long t0 = System.nanoTime();
        try {
            config.initConfig(new Properties(), this.getArgs());
            StringBuilder configBuilder = new StringBuilder(String.format("%s Configuration initialized with values:", ApplicationBoot.BOOT_LOG_PREFIX));
            config.printConfigurationOptions(configBuilder);
            this.log.info(configBuilder.toString());
        }
        catch (Exception e) {
            throw new ApplicationBootInitializerException("Can't load config application values", e);
        }
        this.registerResources(config);
        try {
            this.initUserDirectories(config);
            this.log.info(String.format("%s User directories (%s) initialized.", ApplicationBoot.BOOT_LOG_PREFIX, config.getDataDirectory()));
        }
        catch (Exception e) {
            throw new ApplicationBootInitializerException("Can't init user directories", e);
        }
        try {
            this.initLog(config);
            this.log.info(String.format("%s Logger initialized (use configuration file: %s.", ApplicationBoot.BOOT_LOG_PREFIX, config.getLogConfigurationFile()));
        }
        catch (Exception e) {
            throw new ApplicationBootInitializerException("Can't init log", e);
        }
        try {
            this.initI18n(config);
            this.log.info(String.format("%s I18n (locale %s) is initialized.", ApplicationBoot.BOOT_LOG_PREFIX, config.getApplicationLocale().getDisplayLanguage()));
        }
        catch (Exception e) {
            throw new ApplicationBootInitializerException("Can't init i18n", e);
        }
        try {
            this.initUIConfiguration(config);
        }
        catch (Exception e) {
            throw new ApplicationBootInitializerException("Can't init ui configuration", e);
        }
        try {
            this.initExtra(config, context);
        }
        catch (Exception e) {
            throw new ApplicationBootInitializerException("Can't init extra", e);
        }
        try {
            this.initComponents(config, context);
        }
        catch (Exception e) {
            throw new ApplicationBootInitializerException("Can't init components", e);
        }
        String time = Strings.convertTime((long)t0, (long)System.nanoTime());
        this.log.info(String.format("%s Context was initialized in %s.", ApplicationBoot.BOOT_LOG_PREFIX, time));
    }

    protected void registerResources(Config config) {
        this.resourceManager.registerResource(new ApplicationResourceManager.ClassPathResource(I18N_ARCHIVE));
        this.LOG_CONFIGURATION_FILE = config.get().replaceRecursiveOptions(this.LOG_CONFIGURATION_FILE);
        this.resourceManager.registerResource(new ApplicationResourceManager.ClassPathResource(this.LOG_CONFIGURATION_FILE));
    }

    public void initExtra(Config config, Context context) {
    }

    protected final void initComponents(Config configuration, Context context) {
        for (ApplicationContextComponent<Config, Context, ?> component : context.components()) {
            component.set(context, configuration);
        }
    }

    protected ApplicationResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected void initI18n(Config config) {
        I18n.close();
        File i18nDirectory = config.getI18nDirectory();
        I18nConfiguration i18nConfiguration = I18nConfiguration.createDefaultConfiguration();
        UserI18nBootLoader i18nInitializer = new UserI18nBootLoader(i18nDirectory.toPath(), (I18nBootLoader)new DefaultI18nBootLoader(i18nConfiguration), (ApplicationConfiguration)config){
            final /* synthetic */ ApplicationConfiguration val$config;
            {
                this.val$config = applicationConfiguration;
                super(userDirectory, delegate);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void createUserI18nLayout(Path directory, I18nLanguageProvider delegateLanguageProvider) throws Exception {
                if (this.val$config.getI18nDefinitionFile().exists()) {
                    return;
                }
                super.createUserI18nLayout(directory, delegateLanguageProvider);
                URL resource = ApplicationBootInitializerSupport.this.resourceManager.getResourceUrl(ApplicationBootInitializerSupport.I18N_ARCHIVE);
                File archive = new File(directory.getParent().toFile(), ApplicationBootInitializerSupport.this.resourceManager.getResourceFilename(ApplicationBootInitializerSupport.I18N_ARCHIVE));
                try {
                    ApplicationBootInitializerSupport.this.getResourceManager().copyResource(resource, archive, String.format("%s Copy i18n archive", ApplicationBoot.BOOT_LOG_PREFIX));
                    Zips.uncompressFiltred((File)archive, (File)directory.toFile().getParentFile(), (String[])new String[0]);
                }
                catch (Throwable throwable) {
                    if (Files.exists(archive.toPath(), new LinkOption[0])) {
                        try {
                            Files.delete(archive.toPath());
                        }
                        catch (IOException e) {
                            ApplicationBootInitializerSupport.this.log.error(String.format("Could not delete i18n archive %s", archive));
                        }
                    }
                    throw throwable;
                }
                if (Files.exists(archive.toPath(), new LinkOption[0])) {
                    try {
                        Files.delete(archive.toPath());
                    }
                    catch (IOException e) {
                        ApplicationBootInitializerSupport.this.log.error(String.format("Could not delete i18n archive %s", archive));
                    }
                }
            }
        };
        long t00 = System.nanoTime();
        Locale locale = config.getApplicationLocale();
        I18n.init((I18nBootLoader)i18nInitializer, (Locale)locale);
        this.log.debug("i18n language : " + locale);
        this.log.debug("i18n loading time : " + Strings.convertTime((long)t00, (long)System.nanoTime()));
    }

    protected void initLog(Config config) throws IOException {
        File logFile = config.getLogConfigurationFile();
        Preconditions.checkState((boolean)logFile.exists(), (String)"Log config file %s does not exist.", (Object)logFile);
        this.log.debug(String.format("%s Loading log configuration from %s", ApplicationBoot.BOOT_LOG_PREFIX, logFile));
        List<String> configLines = Files.readAllLines(logFile.toPath(), StandardCharsets.UTF_8);
        List<String> finalLogConfigurationProperties = ApplicationConfiguration.loadProperties(configLines, config.get());
        StringBuilder finalConfiguration = new StringBuilder();
        for (String finalLogConfigurationProperty : finalLogConfigurationProperties) {
            finalConfiguration.append(finalLogConfigurationProperty).append("\n");
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(finalConfiguration.toString().getBytes(StandardCharsets.UTF_8));){
            Configurator.initialize(null, (ConfigurationSource)new ConfigurationSource((InputStream)inputStream));
        }
        this.log = LogManager.getLogger(this.getClass());
        this.log.debug(String.format("%s Final log configuration done with file %s", ApplicationBoot.BOOT_LOG_PREFIX, logFile));
    }

    protected void initUserDirectories(Config config) throws IOException {
        File dataDirectory = this.getResourceManager().createDirectory(config.getDataDirectory());
        this.log.debug(String.format("user data directory : %s", dataDirectory));
        this.getResourceManager().createDirectory(config.getTmpDirectory());
        FileUtils.cleanDirectory((File)config.getTmpDirectory());
        File resourcesDirectory = config.getResourcesDirectory();
        if (resourcesDirectory.exists() && !config.getApplicationBuildVersion().equals((Object)config.getApplicationVersion())) {
            this.log.debug(String.format("clear user resource data directory: %s", resourcesDirectory));
            if (config.getI18nDirectory().exists()) {
                FileUtils.cleanDirectory((File)config.getI18nDirectory());
            }
            if (config.getLogConfigurationFile().exists()) {
                FileUtils.deleteQuietly((File)config.getLogConfigurationFile());
            }
        }
        this.getResourceManager().createDirectory(resourcesDirectory);
        this.log.debug(String.format("user resource data directory: %s", resourcesDirectory));
        this.initLogFileDirectory(config);
    }

    protected void initLogFileDirectory(Config config) throws IOException {
        File file = config.getLogConfigurationFile();
        if (!file.exists()) {
            String message = String.format("%s Copy default log configuration file: %s", ApplicationBoot.BOOT_LOG_PREFIX, file);
            this.getResourceManager().copyResource(this.LOG_CONFIGURATION_FILE, file, message);
        }
    }

    protected void initUIConfiguration(Config config) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        try {
            SwingUtil.initNimbusLoookAndFeel();
        }
        catch (Exception e) {
            this.log.warn("Could not use Look and Fell Nimbus, need at least version 1.6u10 of java.");
        }
        catch (Throwable e) {
            this.log.warn("No gui environment found");
        }
        UIResourcesProviders.load();
    }
}

