/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application;

import io.ultreia.java4all.util.SingletonSupplier;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.application.ApplicationBootInitializer;
import org.nuiton.jaxx.runtime.application.ApplicationBootInitializerException;
import org.nuiton.jaxx.runtime.application.ApplicationConfiguration;
import org.nuiton.jaxx.runtime.application.ApplicationContext;
import org.nuiton.jaxx.runtime.application.ApplicationInstances;
import org.nuiton.jaxx.runtime.application.action.ActionExecutor;

public final class ApplicationBoot<Config extends ApplicationConfiguration, Context extends ApplicationContext<Config, Context>> {
    private static final Logger log = LogManager.getLogger(ApplicationBoot.class);
    private static final Object bootLock = new Object();
    public static String BOOT_LOG_PREFIX = "";
    private static ApplicationBoot<?, ?> INSTANCE;
    private final ApplicationBootInitializer<Config, Context> initializer;
    private final SingletonSupplier<Config> configuration;
    private final SingletonSupplier<Context> context;
    private final SingletonSupplier<ApplicationThreadFactory> threadFactory;
    private SingletonSupplier<ActionExecutor> executor;
    private boolean closed;
    private boolean shutdown;
    private boolean reload;
    private boolean closing;

    private ApplicationBoot(ApplicationBootInitializer<Config, Context> initializer) {
        this.initializer = initializer;
        this.initializer.initOnce();
        this.configuration = SingletonSupplier.of(() -> this.initializer.createConfiguration(this));
        this.context = SingletonSupplier.of(() -> this.initializer.createContext(this, this.getConfiguration()));
        this.threadFactory = SingletonSupplier.of(() -> new ApplicationThreadFactory());
        this.executor = SingletonSupplier.of(() -> this.initializer.createExecutor(this, this.getConfiguration(), this.getContext()));
        INSTANCE = this;
    }

    public static synchronized <Config extends ApplicationConfiguration, Context extends ApplicationContext<Config, Context>> ApplicationBoot<Config, Context> create(ApplicationBootInitializer<Config, Context> initializer) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Boot is already init");
        }
        return new ApplicationBoot<Config, Context>(Objects.requireNonNull(initializer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lockBoot() throws InterruptedException {
        Object object = bootLock;
        synchronized (object) {
            bootLock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockBoot() {
        Object object = bootLock;
        synchronized (object) {
            bootLock.notifyAll();
        }
    }

    public static void handlingError(String message, Exception e) {
        ApplicationInstances.context().handlingError(message, e);
    }

    public static void handlingError(Exception e) {
        ApplicationInstances.context().handlingError(e);
    }

    public static ApplicationBootInitializer initializer() {
        return ApplicationBoot.boot().initializer;
    }

    public static <C extends ApplicationBootInitializer> C initializer(Class<C> contextType) {
        return (C)((ApplicationBootInitializer)contextType.cast(ApplicationBoot.initializer()));
    }

    public static ApplicationBoot<?, ?> boot() {
        return Objects.requireNonNull(INSTANCE, "boot is not init.");
    }

    public static void cleanMemory() {
        System.runFinalization();
        System.gc();
    }

    public static <O> O newInstanceWithParams(Class<O> type, Object ... constructorParams) {
        try {
            return (O)ConstructorUtils.invokeConstructor(Objects.requireNonNull(type), (Object[])constructorParams);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Can't instantiate " + type.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void startInThread() {
        Runtime.getRuntime().addShutdownHook(((ApplicationThreadFactory)this.threadFactory.get()).newThread(this::shutdown, "shutdown", false));
        boolean shutdown = false;
        while (!shutdown) {
            block13: {
                Thread thread = ((ApplicationThreadFactory)this.threadFactory.get()).newThread(this::start, "main", false);
                thread.start();
                ApplicationBoot.lockBoot();
                log.info(String.format("%s Application boot unlock...", BOOT_LOG_PREFIX));
                if (!this.reload) break block13;
                try {
                    this.close();
                }
                catch (Exception e) {
                    log.error(String.format("Could not close boot, will shutdown application: %s", e.getMessage()), (Throwable)e);
                    shutdown = true;
                }
                continue;
            }
            shutdown = true;
            continue;
            catch (InterruptedException e) {
                block14: {
                    try {
                        log.error(String.format("Main thread was interrupted for reason %s", e.getMessage()), (Throwable)e);
                        if (!this.reload) break block14;
                    }
                    catch (Throwable throwable) {
                        if (this.reload) {
                            try {
                                this.close();
                            }
                            catch (Exception e2) {
                                log.error(String.format("Could not close boot, will shutdown application: %s", e2.getMessage()), (Throwable)e2);
                                shutdown = true;
                            }
                        } else {
                            shutdown = true;
                        }
                        throw throwable;
                    }
                    try {
                        this.close();
                    }
                    catch (Exception e3) {
                        log.error(String.format("Could not close boot, will shutdown application: %s", e3.getMessage()), (Throwable)e3);
                        shutdown = true;
                    }
                    continue;
                }
                shutdown = true;
            }
        }
        this.shutdown();
    }

    public void start() {
        this.closing = false;
        this.closed = false;
        this.reload = false;
        try {
            this.initializer.init(this.getConfiguration(), this.getContext());
        }
        catch (ApplicationBootInitializerException e) {
            log.error("Could not init boot", (Throwable)e);
            this.shutdown();
        }
        if (this.shutdown) {
            return;
        }
        try {
            this.initializer.start(this.getConfiguration(), this.getContext());
        }
        catch (Exception e) {
            log.error("Could not start boot", (Throwable)e);
            this.shutdown();
        }
    }

    public void restart() {
        this.reload = true;
        ApplicationBoot.unlockBoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        log.info(String.format("%s Ask to shutdown application at %s", BOOT_LOG_PREFIX, new Date()));
        int exitCode = 0;
        try {
            this.close();
        }
        catch (Exception e) {
            exitCode = 1;
            log.error(String.format("Can't shutdown properly application: %s", e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                this.initializer.close();
            }
            finally {
                INSTANCE = null;
                this.exit(exitCode);
            }
        }
    }

    public void addAction(String actionLabel, Runnable action) {
        this.getExecutor().addAction(actionLabel, action);
    }

    public ApplicationThreadFactory getThreadFactory() {
        this.checkNotClosed("threadFactory");
        return (ApplicationThreadFactory)this.threadFactory.get();
    }

    public Context getContext() {
        this.checkNotClosed("context");
        return (Context)((ApplicationContext)this.context.get());
    }

    public Config getConfiguration() {
        this.checkNotClosed("configuration");
        return (Config)((ApplicationConfiguration)this.configuration.get());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void checkNotClosed(String stateName) {
        if (this.closed) {
            throw new IllegalStateException(String.format("Can't get access boot internal state: %s, boot is closing (or closed).", stateName));
        }
    }

    protected final void finalize() throws Throwable {
        if (!this.shutdown) {
            this.shutdown();
        }
        super.finalize();
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void close() {
        if (this.closed || this.closing) {
            return;
        }
        this.closing = true;
        try {
            if (this.context.withValue()) {
                ((ApplicationContext)this.context.get()).close();
            }
            if (this.executor.withValue()) {
                ((ActionExecutor)this.executor.get()).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't close boot for reason: " + e.getMessage(), e);
        }
        finally {
            ApplicationBoot.cleanMemory();
            this.configuration.clear();
            this.context.clear();
            this.executor.clear();
            this.closed = true;
        }
    }

    private void exit(int code) {
        log.debug(String.format("%s Ask to exit application with code: %s", BOOT_LOG_PREFIX, code));
        if (this.initializer.haltOnExit()) {
            Runtime.getRuntime().halt(code);
        }
        log.info(String.format("%s Application exit at %s", BOOT_LOG_PREFIX, new Date()));
    }

    private ActionExecutor getExecutor() {
        this.checkNotClosed("executor");
        return (ActionExecutor)this.executor.get();
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.getExecutor().getWorkersExecutorService();
    }

    public static class ApplicationThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private ApplicationThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(Objects.requireNonNull(r));
            thread.setName("Application." + thread.getName());
            thread.setDaemon(true);
            return thread;
        }

        public Thread newThread(Runnable r, String name, boolean daemon) {
            Thread thread = this.newThread(Objects.requireNonNull(r));
            thread.setName("Application." + Objects.requireNonNull(name));
            thread.setDaemon(daemon);
            return thread;
        }
    }
}

