/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.swing.ApplicationAction;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class KeyStrokes {
    public static void addKeyStroke(AbstractButton component, KeyStroke actionKey) {
        String actionStr = SwingUtil.keyStrokeToStr(actionKey);
        if (component.getText() != null && !component.getText().contains(actionStr)) {
            String text = component.getText() + actionStr;
            component.setText(text);
        }
        if (component.getToolTipText() != null && !component.getToolTipText().contains(actionStr)) {
            String tip = component.getToolTipText() + actionStr;
            component.setToolTipText(tip);
        }
    }

    public static String suffixTextWithKeyStroke(String text, KeyStroke keyStroke) {
        text = (String)text + SwingUtil.keyStrokeToStr(keyStroke);
        return text;
    }

    public static void addKeyStrokeFromMnemonic(AbstractButton editor) {
        int mnemonic = editor.getMnemonic();
        if (mnemonic > 0) {
            String accelerator = " (Alt + " + (char)mnemonic + ")";
            if (editor.getText() != null) {
                editor.setText(editor.getText() + accelerator);
            }
            if (editor.getToolTipText() != null) {
                editor.setToolTipText(editor.getToolTipText() + accelerator);
            }
        }
    }

    public static void addKeyStrokeFromMnemonic(JAXXObject jaxxObject) {
        LinkedHashSet<JAXXObject> done = new LinkedHashSet<JAXXObject>();
        KeyStrokes.addKeyStrokeFromMnemonic(jaxxObject, done);
    }

    protected static void addKeyStrokeFromMnemonic(JAXXObject jaxxObject, Set<JAXXObject> done) {
        if (done.contains(jaxxObject)) {
            return;
        }
        done.add(jaxxObject);
        jaxxObject.get$objectMap().values().stream().filter(o -> !(o instanceof JMenuItem) && o instanceof AbstractButton).forEach(o -> {
            AbstractButton b = (AbstractButton)o;
            if (b.getAction() == null || b.getAction().getValue("AcceleratorKey") == null) {
                KeyStrokes.addKeyStrokeFromMnemonic((AbstractButton)o);
            }
        });
        jaxxObject.get$objectMap().values().stream().filter(o -> o instanceof JAXXObject).forEach(o -> KeyStrokes.addKeyStrokeFromMnemonic((JAXXObject)o, done));
    }

    public static void addKeyStoreToText(AbstractButton editor, ApplicationAction action) {
        if (editor.getText() != null) {
            editor.setText(KeyStrokes.suffixTextWithKeyStroke(editor.getText(), action.getAcceleratorKey()));
        }
        if (editor.getToolTipText() != null) {
            editor.setToolTipText(KeyStrokes.suffixTextWithKeyStroke(editor.getToolTipText(), action.getAcceleratorKey()));
        }
    }

    public static String removeAcceleratorKey(String text) {
        int endIndex = text.indexOf(40);
        return endIndex == -1 ? text : text.substring(0, endIndex);
    }
}

