/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.model;

import io.ultreia.java4all.decoration.Decorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.model.JaxxDefaultComboBoxModel;

public class JaxxFilterableComboBoxModel<E>
extends JaxxDefaultComboBoxModel<E> {
    public static final Character DEFAULT_WILDCARD_CHARACTER = Character.valueOf('*');
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(JaxxFilterableComboBoxModel.class);
    protected final List<E> filteredItems = new ArrayList();
    protected final List<Predicate<E>> filters = new ArrayList<Predicate<E>>();
    protected String filterText;
    protected Character wildcardCharacter = DEFAULT_WILDCARD_CHARACTER;
    protected Decorator decorator;
    private boolean adjusting;

    public JaxxFilterableComboBoxModel() {
    }

    @SafeVarargs
    public JaxxFilterableComboBoxModel(E ... items) {
        this(Arrays.asList(items));
    }

    public JaxxFilterableComboBoxModel(Collection<E> v) {
        this.delegate = new ArrayList<E>(v);
    }

    @Override
    public int getIndexOf(E anObject) {
        return this.filteredItems.indexOf(anObject);
    }

    @Override
    public void addAllElements(Collection<E> objects) {
        super.addAllElements(objects);
        this.applyFilter();
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.applyFilter();
    }

    @Override
    public int getSize() {
        return this.filteredItems.size();
    }

    @Override
    public E getElementAt(int index) {
        E result = index >= 0 && index < this.filteredItems.size() ? (E)this.filteredItems.get(index) : null;
        return result;
    }

    @Override
    public void addElement(Object anObject) {
        super.addElement(anObject);
        this.applyFilter();
    }

    @Override
    public void insertElementAt(Object anObject, int index) {
        super.insertElementAt(anObject, index);
        this.applyFilter();
    }

    @Override
    public void removeElementAt(int index) {
        super.removeElementAt(index);
        this.applyFilter();
    }

    @Override
    public void removeElement(Object anObject) {
        super.removeElement(anObject);
        this.applyFilter();
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        String oldFilterText = this.filterText;
        this.filterText = filterText;
        log.info(String.format("Set new filter text: '%s'", filterText));
        this.applyFilter();
    }

    public Character getWildcardCharacter() {
        return this.wildcardCharacter;
    }

    public void setWildcardCharacter(Character wildcardCharacter) {
        this.wildcardCharacter = Objects.requireNonNull(wildcardCharacter, "WildcardCharacter can not be null");
        this.applyFilter();
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(Decorator decorator) {
        this.decorator = decorator;
    }

    public void addFilter(Predicate<E> filter) {
        this.filters.add(filter);
        this.applyFilter();
    }

    public void removeFilter(Predicate<E> filter) {
        this.filters.remove(filter);
        this.applyFilter();
    }

    public void clearFilters() {
        this.filters.clear();
        this.applyFilter();
    }

    public void refreshFilteredElements() {
        this.applyFilter();
    }

    protected void applyFilter() {
        this.filteredItems.clear();
        if ((StringUtils.isEmpty((CharSequence)this.filterText) || this.wildcardCharacter != null && StringUtils.isEmpty((CharSequence)StringUtils.remove((String)this.filterText, (char)this.wildcardCharacter.charValue()))) && this.filters.isEmpty()) {
            log.info(String.format("Using all items (filterText: '%s')", this.filterText));
            this.filteredItems.addAll(this.delegate);
        } else {
            Object element;
            boolean addElement;
            Pattern pattern = null;
            if (StringUtils.isNotBlank((CharSequence)this.filterText)) {
                String patternText = Pattern.quote(this.filterText).replace(this.wildcardCharacter.toString(), "\\E.*\\Q") + ".*";
                pattern = Pattern.compile(patternText, 2);
            }
            boolean withoutPattern = pattern == null;
            Iterator iterator = this.delegate.iterator();
            while (iterator.hasNext() && (addElement = this.canAddElement(element = iterator.next()))) {
                String decoratedElement = this.decorateElement(element);
                boolean matches = withoutPattern || pattern.matcher(decoratedElement).matches();
                if (!matches) continue;
                this.filteredItems.add(element);
            }
        }
        log.info("After apply filter, nb items: " + this.getSize());
        if (!this.isAdjusting()) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    public String decorateElement(E element) {
        return this.decorator == null ? String.valueOf(element) : this.decorator.decorate(element);
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public void setAdjusting(boolean adjusting) {
        this.adjusting = adjusting;
    }

    protected boolean canAddElement(E element) {
        for (Predicate<E> filter : this.filters) {
            if (filter.test(element)) continue;
            return false;
        }
        return true;
    }
}

