/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public interface MenuAction
extends Action {
    public static KeyStroke getMenuKeyStroke(JPopupMenu popupMenu) {
        return KeyStroke.getKeyStroke("pressed " + (char)(65 + popupMenu.getSubElements().length));
    }

    public static void preparePopup(JPopupMenu popupMenu, JComponent c, boolean selectLast) {
        if (popupMenu.isVisible()) {
            popupMenu.setVisible(false);
            return;
        }
        popupMenu.setBorderPainted(true);
        popupMenu.pack();
        Dimension dim = popupMenu.getPreferredSize();
        int x = (int)(c.getPreferredSize().getWidth() - dim.getWidth());
        int y = c.getHeight();
        popupMenu.show(c, x, y);
        if (selectLast) {
            MenuAction.selectLast(popupMenu);
        } else {
            MenuAction.selectFirst(popupMenu);
        }
    }

    public static void selectFirst(JPopupMenu popupMenu) {
        int componentCount = popupMenu.getComponentCount();
        if (componentCount == 0) {
            return;
        }
        int index = 0;
        Component component = popupMenu.getComponent(index);
        while (!(component instanceof MenuElement) || !component.isEnabled()) {
            if (index >= componentCount) {
                return;
            }
            component = popupMenu.getComponent(index++);
        }
        MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{popupMenu, (MenuElement)((Object)component)});
    }

    public static void selectLast(JPopupMenu popupMenu) {
        int componentCount = popupMenu.getComponentCount();
        if (componentCount == 0) {
            return;
        }
        int index = componentCount - 1;
        Component component = popupMenu.getComponent(index);
        while (!(component instanceof MenuElement) || !component.isEnabled()) {
            if (index == 0) {
                return;
            }
            component = popupMenu.getComponent(index--);
        }
        MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{popupMenu, (MenuElement)((Object)component)});
    }

    public JPopupMenu getPopupMenu();

    public AbstractButton getEditor();

    public void setKeyStroke(KeyStroke var1);

    default public void initUI() {
        KeyStroke keyStroke = this.getMenuKeyStroke();
        this.setKeyStroke(keyStroke);
        AbstractButton editor = this.getEditor();
        this.getPopupMenu().add(editor);
        this.initEditor();
    }

    default public void initEditor() {
        AbstractButton editor = this.getEditor();
        editor.setOpaque(true);
        editor.setBackground(Color.WHITE);
    }

    default public KeyStroke getMenuKeyStroke() {
        return MenuAction.getMenuKeyStroke(this.getPopupMenu());
    }
}

