/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application.command;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.application.ApplicationConfiguration;
import org.nuiton.jaxx.runtime.application.ApplicationContext;
import org.nuiton.jaxx.runtime.application.ApplicationInstances;
import org.nuiton.jaxx.runtime.application.action.ActionWorker;

public abstract class CommandSupport<Config extends ApplicationConfiguration, Context extends ApplicationContext<Config, Context>> {
    protected final Logger log = LogManager.getLogger(this.getClass());

    public abstract void run() throws InterruptedException;

    public final void start() throws InterruptedException {
        try {
            this.run();
        }
        finally {
            this.getContext().unlock();
        }
    }

    protected final Config getConfig() {
        return this.getContext().getConfig();
    }

    protected final void launchAction(String title, Runnable target) throws InterruptedException {
        CommandLineActionWorker worker = new CommandLineActionWorker(title, target);
        this.getContext().addAction(worker.getActionLabel(), worker);
        this.getContext().lock();
    }

    public Context getContext() {
        return (Context)Objects.requireNonNull(ApplicationInstances.context());
    }

    public class CommandLineActionWorker
    extends ActionWorker<Void, String> {
        CommandLineActionWorker(String actionLabel, Runnable target) {
            super(actionLabel);
            this.setTarget(target);
        }

        public CommandSupport getAction() {
            return CommandSupport.this;
        }
    }
}

