/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application.action.event;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.application.action.ActionWorker;
import org.nuiton.jaxx.runtime.application.action.WizardActionWorker;
import org.nuiton.jaxx.runtime.application.action.event.ActionExecutorEvent;
import org.nuiton.jaxx.runtime.application.action.event.ActionExecutorListener;
import org.nuiton.jaxx.runtime.swing.wizard.WizardModel;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardExtModel;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardState;

public class WizardActionWorkerExecutorListener
implements ActionExecutorListener {
    private static final Logger log = LogManager.getLogger(WizardActionWorkerExecutorListener.class);

    @Override
    public void onActionStart(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        if (source instanceof WizardActionWorker) {
            WizardActionWorker admin = (WizardActionWorker)source;
            Object model = admin.getModel();
            ((WizardModel)model).setBusy(true);
            ((WizardExtModel)model).setStepState(WizardState.RUNNING);
        }
    }

    @Override
    public void onActionFail(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        Exception error = source.getError();
        if (source instanceof WizardActionWorker) {
            WizardActionWorker admin = (WizardActionWorker)source;
            Object model = admin.getModel();
            ((WizardExtModel)model).setErrorOnStepModel(error);
            ((WizardExtModel)model).setStepState(WizardState.FAILED);
        }
    }

    @Override
    public void onActionCancel(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        if (source instanceof WizardActionWorker) {
            WizardActionWorker admin = (WizardActionWorker)source;
            Object model = admin.getModel();
            ((WizardExtModel)model).setStepState(WizardState.CANCELED);
        }
    }

    @Override
    public void onActionEnd(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        if (source instanceof WizardActionWorker) {
            WizardActionWorker admin = (WizardActionWorker)source;
            try {
                WizardState state = (WizardState)((Object)admin.get());
                ((WizardExtModel)admin.getModel()).setStepState(state);
            }
            catch (Exception e) {
                log.error(String.format("Could not get data from worker %s", admin), (Throwable)e);
            }
        }
    }

    @Override
    public void onAfterAction(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        if (source instanceof WizardActionWorker) {
            WizardActionWorker admin = (WizardActionWorker)source;
            Object model = admin.getModel();
            ((WizardModel)model).setBusy(false);
        }
    }
}

