/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application.action.event;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.application.ApplicationContext;
import org.nuiton.jaxx.runtime.application.action.ActionWorker;
import org.nuiton.jaxx.runtime.application.action.event.ActionExecutorEvent;
import org.nuiton.jaxx.runtime.application.action.event.ActionExecutorListener;

public class DefaultActionExecutorListener
implements ActionExecutorListener {
    private static final Logger log = LogManager.getLogger(DefaultActionExecutorListener.class);
    private final ApplicationContext context;

    public DefaultActionExecutorListener(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void onActionStart(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        log.info(String.format("Action [%s] was started at %s", source.getActionLabel(), new Date(source.getStartTime())));
        this.context.busy();
    }

    @Override
    public void onActionFail(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        Exception error = source.getError();
        log.error(String.format("Action [%s] failed with error %s", source.getActionLabel(), error.getCause()), (Throwable)error);
        if (this.context.isClosed()) {
            return;
        }
    }

    @Override
    public void onActionCancel(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        log.info(String.format("Action [%s] was canceled", source.getActionLabel()));
        if (this.context.isClosed()) {
            return;
        }
        log.info(String.format("Action [%s] canceled.", source.getActionLabel()));
    }

    @Override
    public void onActionEnd(ActionExecutorEvent event) {
        ActionWorker source = event.getSource();
        log.info(String.format("Action [%s] was done in %s", source.getActionLabel(), source.getTime()));
        if (this.context.isClosed()) {
            return;
        }
        log.info(String.format("Action [%s] end.", source.getActionLabel()));
    }

    @Override
    public void onAfterAction(ActionExecutorEvent event) {
        long count = event.getExecutor().getNbActions();
        ActionWorker source = event.getSource();
        log.info(String.format("Action [%s] is consumed (still %d tasks to treat).", source.getActionLabel(), count));
        if (this.context.isClosed()) {
            return;
        }
        if (count < 1L) {
            this.context.notBusy();
        }
    }
}

