/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application.action;

import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.application.ApplicationBoot;
import org.nuiton.jaxx.runtime.application.ApplicationContext;
import org.nuiton.jaxx.runtime.application.action.ActionWorker;
import org.nuiton.jaxx.runtime.application.action.event.ActionExecutorEvent;
import org.nuiton.jaxx.runtime.application.action.event.ActionExecutorListener;
import org.nuiton.jaxx.runtime.application.action.event.DefaultActionExecutorListener;

public class ActionExecutor
implements Closeable {
    private static final Logger log = LogManager.getLogger(ActionExecutor.class);
    private final Set<ActionWorker<?, ?>> tasks = new HashSet();
    private final PropertyChangeListener workerListener;
    private final EventListenerList eventListenerList;
    private final ApplicationBoot boot;
    private ThreadPoolExecutor executorService;

    public ActionExecutor(ApplicationBoot boot, ApplicationContext context) {
        this.boot = boot;
        this.eventListenerList = new EventListenerList();
        this.workerListener = evt -> this.onActionWorkerChanged((ActionWorker)evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        this.addActionExecutorListener(new DefaultActionExecutorListener(context));
    }

    public void addActionExecutorListener(ActionExecutorListener listener) {
        this.eventListenerList.add(ActionExecutorListener.class, Objects.requireNonNull(listener));
    }

    public void removeActionExecutorListener(ActionExecutorListener listener) {
        this.eventListenerList.remove(ActionExecutorListener.class, Objects.requireNonNull(listener));
    }

    public ActionExecutorListener[] getActionExecutorListeners() {
        return (ActionExecutorListener[])this.eventListenerList.getListeners(ActionExecutorListener.class);
    }

    public ActionWorker<?, ?> addAction(String actionLabel, Runnable action) {
        ActionWorker worker = action instanceof ActionWorker ? (ActionWorker)action : new ActionWorker(actionLabel, action);
        worker.addPropertyChangeListener(this.workerListener);
        this.tasks.add(worker);
        log.debug("Launch worker [" + actionLabel + "] now...");
        try {
            this.getWorkersExecutorService().execute(worker);
        }
        catch (RejectedExecutionException e) {
            log.error(String.format("Worker was rejected: %s for reason: %s", worker, e.getMessage()), (Throwable)e);
        }
        log.debug("Launch worker [" + actionLabel + "] is on...");
        return worker;
    }

    @Override
    public void close() {
        log.info("Executor " + this + " is terminating...");
        if (this.executorService != null) {
            try {
                this.executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.error("Can't terminate executor service, will shutdown it.");
            }
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        for (ActionExecutorListener listener : this.getActionExecutorListeners()) {
            this.removeActionExecutorListener(listener);
        }
        log.info("Executor " + this + " is terminated at " + new Date());
    }

    public int getNbActions() {
        return this.getTasks().size();
    }

    public Set<ActionWorker<?, ?>> getTasks() {
        return this.tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onActionWorkerChanged(ActionWorker<?, ?> source, String propertyName, Object oldValue, Object newValue) {
        log.debug(String.format("action %s property %s changed <%s - %s>", source, propertyName, oldValue, newValue));
        switch (propertyName) {
            case "state": {
                SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)Objects.requireNonNull(newValue));
                if (SwingWorker.StateValue.STARTED == state) {
                    this.fireActionStart(this, source);
                    return;
                }
                if (SwingWorker.StateValue.DONE != state) return;
                ActionWorker.ActionStatus status = source.getStatus();
                log.debug(String.format("Action [%s] status = %s", new Object[]{source.getActionLabel(), status}));
                try {
                    switch (status) {
                        case OK: {
                            this.fireActionEnd(this, source);
                            return;
                        }
                        case CANCEL: {
                            this.fireActionCancel(this, source);
                            return;
                        }
                        case FAIL: {
                            this.fireActionFail(this, source);
                            return;
                        }
                    }
                    return;
                }
                finally {
                    source.removePropertyChangeListener(this.workerListener);
                    this.tasks.remove(source);
                    this.fireAfterAction(this, source);
                }
            }
        }
    }

    public ThreadPoolExecutor getWorkersExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(5, 10, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), this.boot.getThreadFactory());
        }
        return this.executorService;
    }

    private void fireActionStart(ActionExecutor executor, ActionWorker<?, ?> source) {
        ActionExecutorEvent event = null;
        for (ActionExecutorListener listener : this.getActionExecutorListeners()) {
            if (event == null) {
                event = new ActionExecutorEvent(source, executor);
            }
            listener.onActionStart(event);
        }
    }

    private void fireActionFail(ActionExecutor executor, ActionWorker<?, ?> source) {
        ActionExecutorEvent event = null;
        for (ActionExecutorListener listener : this.getActionExecutorListeners()) {
            if (event == null) {
                event = new ActionExecutorEvent(source, executor);
            }
            listener.onActionFail(event);
        }
    }

    private void fireActionCancel(ActionExecutor executor, ActionWorker<?, ?> source) {
        ActionExecutorEvent event = null;
        for (ActionExecutorListener listener : this.getActionExecutorListeners()) {
            if (event == null) {
                event = new ActionExecutorEvent(source, executor);
            }
            listener.onActionCancel(event);
        }
    }

    private void fireActionEnd(ActionExecutor executor, ActionWorker<?, ?> source) {
        ActionExecutorEvent event = null;
        for (ActionExecutorListener listener : this.getActionExecutorListeners()) {
            if (event == null) {
                event = new ActionExecutorEvent(source, executor);
            }
            listener.onActionEnd(event);
        }
    }

    private void fireAfterAction(ActionExecutor executor, ActionWorker<?, ?> source) {
        ActionExecutorEvent event = null;
        for (ActionExecutorListener listener : this.getActionExecutorListeners()) {
            if (event == null) {
                event = new ActionExecutorEvent(source, executor);
            }
            listener.onAfterAction(event);
        }
    }
}

