/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.application.ApplicationBoot;
import org.nuiton.jaxx.runtime.application.ApplicationConfiguration;
import org.nuiton.jaxx.runtime.application.ApplicationContext;
import org.nuiton.jaxx.runtime.application.ApplicationContextComponent;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.context.JAXXContextEntryDef;
import org.nuiton.jaxx.runtime.context.JAXXInitialContext;
import org.nuiton.jaxx.runtime.swing.session.SwingSessionHelper;

public abstract class DefaultApplicationContext<Config extends ApplicationConfiguration, Context extends DefaultApplicationContext<Config, Context>>
implements ApplicationContext<Config, Context> {
    private static final Logger log = LogManager.getLogger(DefaultApplicationContext.class);
    private static final JAXXContextEntryDef<DefaultApplicationContext> ENTRY = new JAXXContextEntryDef<DefaultApplicationContext>("ApplicationContext", DefaultApplicationContext.class);
    private final ImmutableMap<String, ApplicationContextComponent<Config, Context, ?>> components;
    private final ImmutableMap<String, ApplicationContextComponent<Config, Context, ?>> variables;
    private final JAXXContext delegate;
    private final ApplicationBoot<Config, Context> boot;
    private final Config config;
    private final Object lock;

    protected DefaultApplicationContext(ApplicationBoot<Config, Context> boot, Config config, List<ApplicationContextComponent<Config, Context, ?>> components, List<ApplicationContextComponent<Config, Context, ?>> variables) {
        this.boot = Objects.requireNonNull(boot);
        this.config = (ApplicationConfiguration)Objects.requireNonNull(config);
        this.components = Maps.uniqueIndex((Iterable)Objects.requireNonNull(components), ApplicationContextComponent::getName);
        this.variables = Maps.uniqueIndex((Iterable)Objects.requireNonNull(variables), ApplicationContextComponent::getName);
        this.lock = new Object();
        this.delegate = new DefaultJAXXContext();
    }

    protected static <Config extends ApplicationConfiguration, Context extends DefaultApplicationContext<Config, Context>> ApplicationContextComponent<Config, Context, SwingSessionHelper> SWING_SESSION_HELPER() {
        return new ApplicationContextComponent<Config, Context, SwingSessionHelper>(SwingSessionHelper.class){

            @Override
            public SwingSessionHelper load(Context context, Config config) {
                return new SwingSessionHelper(config.getSwingSessionFile());
            }
        };
    }

    @Override
    public final void install(JAXXContext context) {
        ENTRY.setContextValue(context, this);
    }

    @Override
    public final JAXXInitialContext toInitialContext() {
        return new JAXXInitialContext().add(ENTRY, this);
    }

    @Override
    public final ApplicationBoot<Config, Context> getBoot() {
        return this.boot;
    }

    @Override
    public final Config getConfig() {
        return this.config;
    }

    @Override
    public final boolean isClosed() {
        return this.getBoot().isClosed();
    }

    public final <T> void setContextValue(T t) {
        this.delegate.setContextValue(t);
    }

    public final <T> void setContextValue(T t, String s) {
        this.delegate.setContextValue(t, s);
    }

    public final <T> void removeContextValue(Class<T> aClass) {
        this.delegate.removeContextValue(aClass);
    }

    public final <T> void removeContextValue(Class<T> aClass, String s) {
        this.delegate.removeContextValue(aClass, s);
    }

    public final <T> T getContextValue(Class<T> aClass) {
        return (T)this.delegate.getContextValue(aClass);
    }

    public final <T> T getContextValue(Class<T> aClass, String s) {
        return (T)this.delegate.getContextValue(aClass, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void lock() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    @Override
    public final List<ApplicationContextComponent<Config, Context, ?>> components() {
        return new ArrayList(this.components.values());
    }

    @Override
    public final List<ApplicationContextComponent<Config, Context, ?>> variables() {
        return new ArrayList(this.variables.values());
    }

    @Override
    public final void close() {
        log.info(String.format("%s Closing application context: %s", ApplicationBoot.BOOT_LOG_PREFIX, this));
        this.removeComponents(this.variables());
        List<ApplicationContextComponent<Config, Context, ?>> components = this.components();
        Collections.reverse(components);
        this.removeComponents(components);
    }

    @Override
    public final void addAction(String actionLabel, Runnable action) {
        this.getBoot().addAction(actionLabel, action);
    }

    private void removeComponents(List<ApplicationContextComponent<Config, Context, ?>> components) {
        for (ApplicationContextComponent<Config, Context, ?> component : components) {
            log.info(String.format("%s Removing %s", ApplicationBoot.BOOT_LOG_PREFIX, component));
            try {
                Object value = component.remove();
                log.info(String.format("%s %s (%s) was removed.", ApplicationBoot.BOOT_LOG_PREFIX, component, value));
            }
            catch (Exception e) {
                log.error(String.format("Can't remove %s: %s", component, e.getMessage()), (Throwable)e);
            }
        }
    }
}

