/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.application;

import io.ultreia.java4all.config.ApplicationConfig;
import io.ultreia.java4all.config.ArgumentsParserException;
import io.ultreia.java4all.config.spi.ApplicationConfigProvider;
import io.ultreia.java4all.config.spi.ConfigActionDef;
import io.ultreia.java4all.config.spi.ConfigOptionDef;
import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.util.Version;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public interface ApplicationConfiguration {
    public static Properties loadProperties(Properties sourceProperties, ApplicationConfig config) {
        Properties targetProperties = new Properties();
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String newValue = config.replaceRecursiveOptions(value);
            targetProperties.setProperty(key, newValue);
        }
        return targetProperties;
    }

    public static List<String> loadProperties(List<String> sourceProperties, ApplicationConfig config) {
        LinkedList<String> targetProperties = new LinkedList<String>();
        for (String entry : sourceProperties) {
            String newValue = config.replaceRecursiveOptions(entry);
            targetProperties.add(newValue);
        }
        return targetProperties;
    }

    public ApplicationConfig get();

    default public String getApplicationId() {
        return this.get().getOption(DefaultOptions.APPLICATION_ID.key);
    }

    default public String getApplicationName() {
        return this.get().getOption(DefaultOptions.APPLICATION_NAME.key);
    }

    default public Version getApplicationVersion() {
        return this.get().getOptionAsVersion(DefaultOptions.APPLICATION_VERSION.key);
    }

    default public String getApplicationOrganizationName() {
        return this.get().getOption(DefaultOptions.APPLICATION_ORGANIZATION_NAME.key);
    }

    default public URL getApplicationOrganizationUrl() {
        return this.get().getOptionAsURL(DefaultOptions.APPLICATION_ORGANIZATION_URL.key);
    }

    default public int getApplicationInceptionYear() {
        return this.get().getOptionAsInt(DefaultOptions.APPLICATION_INCEPTION_YEAR.key);
    }

    default public Locale getApplicationLocale() {
        return this.get().getOptionAsLocale(DefaultOptions.APPLICATION_LOCALE.key);
    }

    default public void setApplicationLocale(Locale applicationLocale) {
        this.get().setOption(DefaultOptions.APPLICATION_LOCALE.key, applicationLocale.toString());
    }

    default public URL getApplicationSiteUrl() {
        return this.get().getOptionAsURL(DefaultOptions.APPLICATION_SITE_URL.key);
    }

    default public String getApplicationLicenseName() {
        return this.get().getOption(DefaultOptions.APPLICATION_LICENSE_NAME.key);
    }

    default public URL getApplicationLicenseUrl() {
        return this.get().getOptionAsURL(DefaultOptions.APPLICATION_LICENSE_URL.key);
    }

    default public Version getApplicationBuildVersion() {
        return this.get().getOptionAsVersion(DefaultOptions.APPLICATION_BUILD_VERSION.key);
    }

    default public Date getApplicationBuildDate() {
        return this.get().getOptionAsDate(DefaultOptions.APPLICATION_BUILD_DATE.key);
    }

    default public String getApplicationBuildNumber() {
        return this.get().getOption(DefaultOptions.APPLICATION_BUILD_NUMBER.key);
    }

    default public File getI18nDirectory() {
        return this.get().getOptionAsFile(DefaultOptions.I18N_DIRECTORY.key);
    }

    default public File getI18nDefinitionFile() {
        return this.get().getOptionAsFile(DefaultOptions.I18N_DEFINITION_FILE.key);
    }

    default public String getI18nBundleName() {
        return this.get().getOption(DefaultOptions.I18N_BUNDLE_NAME.key);
    }

    default public String getI18nProviderName() {
        return this.get().getOption(DefaultOptions.I18N_PROVIDER_NAME.key);
    }

    default public String getI18nPrefix() {
        return this.get().getOption(DefaultOptions.I18N_PREFIX.key);
    }

    default public File getDataDirectory() {
        return this.get().getOptionAsFile(DefaultOptions.DATA_DIRECTORY.key);
    }

    default public File getTmpDirectory() {
        return this.get().getOptionAsFile(DefaultOptions.TMP_DIRECTORY.key);
    }

    default public File getResourcesDirectory() {
        return this.get().getOptionAsFile(DefaultOptions.RESOURCES_DIRECTORY.key);
    }

    default public File getLogConfigurationFile() {
        return this.get().getOptionAsFile(DefaultOptions.LOG_CONFIGURATION_FILE.key);
    }

    default public File getSwingSessionFile() {
        return this.get().getOptionAsFile(DefaultOptions.UI_SWING_SESSION_FILE.key);
    }

    default public boolean isFullScreen() {
        return this.get().getOptionAsBoolean(DefaultOptions.UI_FULL_SCREEN.key);
    }

    default public void setFullScreen(boolean fullScreen) {
        this.get().setOption(DefaultOptions.UI_FULL_SCREEN.key, Boolean.toString(fullScreen));
        this.get().saveForUser(new String[0]);
    }

    default public String getApplicationCopyrightText() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int inceptionYear = this.getApplicationInceptionYear();
        Object copyrightText = String.format("Version %s - %s @ %d", this.getApplicationVersion(), this.getApplicationOrganizationName(), inceptionYear);
        if (year != inceptionYear) {
            copyrightText = (String)copyrightText + " - " + year;
        }
        return copyrightText;
    }

    default public void printConfigurationOptions(StringBuilder builder) {
        ApplicationConfig applicationConfig = this.get();
        builder.append(String.format("\n\t%1$-40s \u2192 %2$s", "Config file", applicationConfig.getUserConfigFile()));
        List<ConfigOptionDef> options = this.getAllOptions();
        for (ConfigOptionDef option : options) {
            builder.append(String.format("\n\t%1$-40s \u2192 %2$s", option.getKey(), applicationConfig.getOption(option.getKey())));
        }
    }

    default public List<ConfigOptionDef> getAllOptions() {
        ArrayList<ConfigOptionDef> options = new ArrayList<ConfigOptionDef>(Arrays.asList(DefaultOptions.values()));
        ApplicationConfigProvider applicationConfigProvider = ApplicationConfigProvider.getProvider((ClassLoader)this.getClass().getClassLoader(), (String)this.getI18nProviderName());
        options.addAll(Arrays.asList(applicationConfigProvider.getOptions()));
        return this.orderedByKey(options);
    }

    default public void printOptions(StringBuilder out, ConfigOptionDef ... options) {
        for (ConfigOptionDef o : options) {
            out.append(String.format("\t%s (%s): %s\n", o.getKey(), o.getDefaultValue(), I18n.t((String)o.getDescription(), (Object[])new Object[0])));
        }
    }

    default public void printActions(StringBuilder out, ConfigActionDef ... actions) {
        for (ConfigActionDef a : actions) {
            out.append(String.format("\t%s (%s): %s\n", Arrays.toString(a.getAliases()), a.getAction(), I18n.t((String)a.getDescription(), (Object[])new Object[0])));
        }
    }

    default public void initConfig(Properties p, String ... args) throws ArgumentsParserException {
        ApplicationConfig applicationConfig = this.get();
        applicationConfig.loadDefaultOptions((ConfigOptionDef[])DefaultOptions.values());
        for (Object k : p.keySet()) {
            String key = String.valueOf(k);
            Object value = p.get(k);
            String strValue = String.valueOf(value);
            applicationConfig.setDefaultOption(key, strValue);
        }
        applicationConfig.parse(args);
        Version version = applicationConfig.getOptionAsVersion(DefaultOptions.APPLICATION_VERSION.key);
        Objects.requireNonNull(version, String.format("Could not find default option %s.", DefaultOptions.APPLICATION_VERSION.key));
        if (version.isSnapshot()) {
            applicationConfig.setOption(DefaultOptions.APPLICATION_VERSION.key, null);
            applicationConfig.setDefaultOption(DefaultOptions.APPLICATION_VERSION.key, Version.removeSnapshot((Version)version).getVersion());
        }
        for (DefaultOptions defaultOption : DefaultOptions.values()) {
            String defaultOptionValue = applicationConfig.getOption(defaultOption.key);
            Objects.requireNonNull(defaultOptionValue, String.format("Could not find default option %s.", defaultOption.key));
        }
    }

    default public List<ConfigOptionDef> orderedByKey(List<ConfigOptionDef> options) {
        ArrayList<ConfigOptionDef> values = new ArrayList<ConfigOptionDef>(options);
        values.sort(Comparator.comparing(ConfigOptionDef::getKey));
        return Collections.unmodifiableList(values);
    }

    public void removeJaxxPropertyChangeListener();

    public static enum DefaultOptions implements ConfigOptionDef
    {
        APPLICATION_ID(String.class, "application.id", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_NAME(String.class, "application.name", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_VERSION(Version.class, "application.version", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_LOCALE(Locale.class, "application.locale", I18n.n((String)"", (Object[])new Object[0]), "fr_FR"),
        APPLICATION_ORGANIZATION_NAME(String.class, "application.organization.name", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_ORGANIZATION_URL(URL.class, "application.organization.url", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_LICENSE_NAME(String.class, "application.license.name", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_LICENSE_URL(URL.class, "application.license.url", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_SITE_URL(URL.class, "application.site.url", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_INCEPTION_YEAR(Integer.TYPE, "application.inceptionYear", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_BUILD_VERSION(Version.class, "application.build.version", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_BUILD_DATE(Date.class, "application.build.date", I18n.n((String)"", (Object[])new Object[0]), null),
        APPLICATION_BUILD_NUMBER(String.class, "application.build.number", I18n.n((String)"", (Object[])new Object[0]), null),
        DATA_DIRECTORY(File.class, "data.directory", I18n.n((String)"", (Object[])new Object[0]), "${user.home}/.${application.id}"),
        RESOURCES_DIRECTORY(File.class, "resources.directory", I18n.n((String)"", (Object[])new Object[0]), "${data.directory}/resources-${application.version}"),
        TMP_DIRECTORY(File.class, "tmp.directory", I18n.n((String)"", (Object[])new Object[0]), "${data.directory}/tmp"),
        LOG_CONFIGURATION_FILE(File.class, "application.log.configuration.file", I18n.n((String)"", (Object[])new Object[0]), "${resources.directory}/${application.id}-log4j.properties"),
        UI_SWING_SESSION_FILE(File.class, "application.ui.swingSessionFile", I18n.n((String)"", (Object[])new Object[0]), "${resources.directory}/${application.id}-swing-session.ui.xml"),
        I18N_DIRECTORY(File.class, "i18n.directory", I18n.n((String)"", (Object[])new Object[0]), "${resources.directory}/i18n"),
        I18N_DEFINITION_FILE(File.class, "i18n.definition.file", I18n.n((String)"", (Object[])new Object[0]), "${i18n.directory}/${i18n.bundle.name}-definition.properties"),
        I18N_PREFIX(String.class, "i18n.prefix", I18n.n((String)"", (Object[])new Object[0]), "${application.id}."),
        I18N_BUNDLE_NAME(String.class, "i18n.bundle.name", I18n.n((String)"", (Object[])new Object[0]), "${application.id}-i18n"),
        I18N_PROVIDER_NAME(String.class, "i18n.provider.name", I18n.n((String)"", (Object[])new Object[0]), "${application.id}Config"),
        UI_FULL_SCREEN(Boolean.TYPE, "ui.full.screen", I18n.n((String)"", (Object[])new Object[0]), "false");

        private final Class type;
        private final String key;
        private final String description;
        private String defaultValue;

        private DefaultOptions(Class type, String key, String description, String defaultValue) {
            this.type = type;
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public Class getType() {
            return this.type;
        }

        public String getDescription() {
            return I18n.t((String)this.description, (Object[])new Object[0]);
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isTransient() {
            return true;
        }

        public void setTransient(boolean _transient) {
        }

        public boolean isFinal() {
            return true;
        }

        public void setFinal(boolean _final) {
        }
    }
}

