package org.nuiton.jaxx.runtime.util;

/*-
 * #%L
 * JAXX :: Runtime
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.decorator.MultiJXPathDecorator;
import io.ultreia.java4all.i18n.spi.bean.BeanPropertyI18nKeyProducer;
import io.ultreia.java4all.i18n.spi.bean.BeanPropertyI18nKeyProducerProvider;

import java.util.LinkedHashMap;

import static io.ultreia.java4all.i18n.I18n.t;

/**
 * Created by tchemit on 18/10/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class I18nLabelUtil {

    public static LinkedHashMap<String, String> computeLabels(MultiJXPathDecorator decorator) {
        BeanPropertyI18nKeyProducer labelsBuilder = BeanPropertyI18nKeyProducerProvider.get().getDefaultLabelsBuilder();
        Class type = decorator.getType();
        LinkedHashMap<String, String> result = new LinkedHashMap<>();
        int nbContext = decorator.getNbContext();
        if (nbContext > 1) {
            for (int i = 0; i < nbContext; i++) {
                String property = labelsBuilder.getI18nPropertyKey(type, decorator.getProperty(i));
                String propertyI18n = t(property);
                result.put(property, propertyI18n);
            }
        }
        return result;
    }
}
