/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import org.nuiton.jaxx.runtime.swing.model.GenericListEvent;
import org.nuiton.jaxx.runtime.swing.model.GenericListListener;

public abstract class AbstractGenericListSelectionModel<B>
extends DefaultListSelectionModel {
    public static final String PROPERTY_SELECTED_VALUE = "selectedValues";
    private static final long serialVersionUID = -8002767572678647733L;
    protected final EventListenerList listenerList = new EventListenerList();
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected List<B> selectedValues = new ArrayList<B>();

    public B getSelectedValue() {
        return this.selectedValues.get(0);
    }

    public List<B> getSelectedValues() {
        return new ArrayList<B>(this.selectedValues);
    }

    public void setSelectedValues(List<B> selectedValues) {
        this.selectedValues = selectedValues;
    }

    protected void unSelectItems(Collection<B> values) {
        ArrayList<B> oldValue = new ArrayList<B>(this.selectedValues);
        for (B value : values) {
            int index = this.selectedValues.indexOf(value);
            this.removeSelectionIntervalWithoutFire(index, index);
        }
        this.fireSelectionRemoved(values);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    protected void unSelectItem(B value) {
        ArrayList<B> oldValue = new ArrayList<B>(this.selectedValues);
        int index = this.selectedValues.indexOf(value);
        this.removeSelectionIntervalWithoutFire(index, index);
        this.fireSelectionRemoved(Collections.singletonList(value));
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    public void addSelectedItem(B toSelect) {
        ArrayList<B> oldValue = new ArrayList<B>(this.selectedValues);
        this.selectedValues.add(toSelect);
        int index = this.selectedValues.indexOf(toSelect);
        super.addSelectionInterval(index, index);
        this.fireSelectionAdded(Collections.singletonList(toSelect));
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    public boolean hasSelectedIndex() {
        return !this.selectedValues.isEmpty();
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        ArrayList<B> oldValue = new ArrayList<B>(this.selectedValues);
        this.addSelectionIntervalWithFire(index0, index1);
        super.addSelectionInterval(index0, index1);
        ArrayList<B> newValue = new ArrayList<B>(this.selectedValues);
        newValue.removeAll(oldValue);
        this.fireSelectionAdded(newValue);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        ArrayList<B> oldValue = new ArrayList<B>(this.selectedValues);
        this.selectedValues.clear();
        this.addSelectionIntervalWithFire(index0, index1);
        super.setSelectionInterval(index0, index1);
        ArrayList<B> newValue = new ArrayList<B>(this.selectedValues);
        newValue.removeAll(oldValue);
        this.fireSelectionAdded(newValue);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        ArrayList<B> oldValue = new ArrayList<B>(this.selectedValues);
        this.removeSelectionIntervalWithoutFire(index0, index1);
        ArrayList<B> newValue = new ArrayList<B>(this.selectedValues);
        newValue.removeAll(oldValue);
        this.fireSelectionRemoved(newValue);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    protected void removeSelectionIntervalWithoutFire(int index0, int index1) {
        if (index0 > index1) {
            int tmp = index1;
            index1 = index0;
            index0 = tmp;
        }
        for (int i = index0; i <= index1; ++i) {
            if (this.selectedValues.size() <= i || i == -1) continue;
            this.selectedValues.remove(i);
        }
        super.removeSelectionInterval(index0, index1);
    }

    protected void addSelectionIntervalWithFire(int index0, int index1) {
        if (index0 > index1) {
            int tmp = index1;
            index1 = index0;
            index0 = tmp;
        }
        for (int i = index0; i <= index1; ++i) {
            if (this.getSize() <= i || i == -1) continue;
            B value = this.getValueAt(i);
            this.selectedValues.add(value);
        }
    }

    public abstract int getSize();

    public abstract B getValueAt(int var1);

    @Override
    public void clearSelection() {
        ArrayList<B> oldValue = new ArrayList<B>(this.selectedValues);
        this.selectedValues.clear();
        super.clearSelection();
        this.fireSelectionRemoved(oldValue);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    protected void fireValuesAdded(Collection<B> values) {
        if (values.isEmpty()) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        GenericListEvent<B> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GenericListListener.class) continue;
            if (e == null) {
                e = new GenericListEvent<B>(this, values);
            }
            ((GenericListListener)listeners[i + 1]).valuesAdded(e);
        }
    }

    protected void fireValuesRemoved(Collection<B> values) {
        if (values.isEmpty()) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        GenericListEvent<B> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GenericListListener.class) continue;
            if (e == null) {
                e = new GenericListEvent<B>(this, values);
            }
            ((GenericListListener)listeners[i + 1]).valuesRemoved(e);
        }
    }

    protected void fireSelectionAdded(Collection<B> selectedValues) {
        if (selectedValues.isEmpty()) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        GenericListEvent<B> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GenericListListener.class) continue;
            if (e == null) {
                e = new GenericListEvent<B>(this, selectedValues);
            }
            ((GenericListListener)listeners[i + 1]).selectionAdded(e);
        }
    }

    protected void fireSelectionRemoved(Collection<B> selectedValues) {
        if (selectedValues.isEmpty()) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        GenericListEvent<B> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GenericListListener.class) continue;
            if (e == null) {
                e = new GenericListEvent<B>(this, selectedValues);
            }
            ((GenericListListener)listeners[i + 1]).selectionAdded(e);
        }
    }

    public void addGenericListListener(GenericListListener l) {
        this.listenerList.add(GenericListListener.class, l);
    }

    public void removeGenericListListener(GenericListListener l) {
        this.listenerList.remove(GenericListListener.class, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }
}

