/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.binding;

import java.beans.PropertyChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXUtil;

public abstract class DefaultJAXXBinding
implements JAXXBinding {
    private static final Logger log = LogManager.getLogger(DefaultJAXXBinding.class);
    private static long NB;
    private long nb;
    private final String id;
    protected final JAXXObject source;
    protected final boolean defaultBinding;
    protected final boolean reloadAfterFire;
    private static final String LOG_START_PATTERN = ">>     (hits:%1$5d, total:%2$5d) on %3$s";
    private static final String LOG_END_PATTERN = "<< %4$3d (hits:%1$5d, total:%2$5d) on %3$s";

    public DefaultJAXXBinding(JAXXObject source, String id, boolean defaultBinding) {
        this(source, id, defaultBinding, false);
    }

    public DefaultJAXXBinding(JAXXObject source, String id, boolean defaultBinding, boolean reloadAfterFire) {
        this.source = source;
        this.id = id;
        this.defaultBinding = defaultBinding;
        this.reloadAfterFire = reloadAfterFire;
    }

    public String getId() {
        return this.id;
    }

    public JAXXObject getSource() {
        return this.source;
    }

    public boolean isDefaultBinding() {
        return this.defaultBinding;
    }

    public String toString() {
        return super.toString() + ":" + this.id;
    }

    public void propertyChange(PropertyChangeEvent e) {
        long count = NB++;
        if (log.isDebugEnabled()) {
            log.debug(String.format(LOG_START_PATTERN, ++this.nb, NB, this));
        }
        this.source.processDataBinding(this.id);
        if (this.reloadAfterFire) {
            JAXXUtil.reloadBinding(this);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format(LOG_END_PATTERN, ++this.nb, ++NB, this, NB - count));
        }
    }
}

