/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.action;

import com.google.common.collect.ImmutableMap;
import io.ultreia.java4all.bean.AbstractJavaBean;
import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.lang.Objects2;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.swing.BlockingLayerUI;
import org.nuiton.jaxx.runtime.swing.JOptionPanes;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public abstract class JAXXObjectActionSupport<UI extends JAXXObject>
extends AbstractJavaBean
implements Action {
    public static final String ACTION_TYPE = "actionType";
    public static final String EDITOR = "editor";
    public static final String ACTIVATE_FROM_POPUP = "activateFromPopup";
    private static final Logger log = LogManager.getLogger(JAXXObjectActionSupport.class);
    private static final String ENABLED = "enabled";
    private static final ImmutableMap<String, String> PROPERTY_MAPPING = ImmutableMap.builder().put((Object)"ActionCommandKey", (Object)"actionCommandKey").put((Object)"Name", (Object)"text").put((Object)"ShortDescription", (Object)"tooltipText").put((Object)"AcceleratorKey", (Object)"acceleratorKey").put((Object)"SmallIcon", (Object)"icon").put((Object)"SwingLargeIconKey", (Object)"largeIcon").put((Object)"MnemonicKey", (Object)"mnemonic").put((Object)"SwingSelectedKey", (Object)"selectedKey").put((Object)"SwingDisplayedMnemonicIndexKey", (Object)"displayMnemonicIndexKey").build();
    protected UI ui;
    protected AbstractButton editor;
    private String name;
    private String text;
    private String tooltipText;
    private boolean enabled = true;
    private boolean selectedKey;
    private boolean addKeyStrokeToText = true;
    private boolean addMnemonicAsKeyStroke = true;
    private KeyStroke keyStroke;
    private int mnemonic;
    private int displayMnemonicIndexKey = -1;
    private Icon icon;
    private Icon largeIcon;
    private boolean checkMenuItemIsArmed = true;
    private final PropertyChangeListener onEnabledChanged;

    protected JAXXObjectActionSupport(String label, String shortDescription, String actionIcon, KeyStroke acceleratorKey) {
        this(null, label, shortDescription, actionIcon, acceleratorKey);
    }

    protected JAXXObjectActionSupport(String actionCommandKey, String label, String shortDescription, String actionIcon, KeyStroke acceleratorKey) {
        this(actionCommandKey, label, shortDescription, actionIcon);
        this.keyStroke = acceleratorKey;
    }

    protected JAXXObjectActionSupport(String label, String shortDescription, String actionIcon, char acceleratorKey) {
        this(null, label, shortDescription, actionIcon, acceleratorKey);
    }

    protected JAXXObjectActionSupport(String actionCommandKey, String label, String shortDescription, String actionIcon, char acceleratorKey) {
        this(actionCommandKey, label, shortDescription, actionIcon);
        this.mnemonic = acceleratorKey;
    }

    public static void makeActionsEnabledOnlyIfMenuItemParentIsOpened(JMenuBar menuBar) {
        for (Component component : menuBar.getComponents()) {
            if (!(component instanceof JMenu)) continue;
            JAXXObjectActionSupport.makeActionsEnabledOnlyIfMenuItemParentIsOpened((JMenu)component);
        }
    }

    protected static void makeActionsEnabledOnlyIfMenuItemParentIsOpened(JMenu menu) {
        MakeActionsEnabledOnlyIfMenuItemParentIsOpenedPopupMenuListener listener = new MakeActionsEnabledOnlyIfMenuItemParentIsOpenedPopupMenuListener(menu);
        menu.getPopupMenu().addPopupMenuListener(listener);
        for (Component component : menu.getMenuComponents()) {
            if (!(component instanceof JMenu)) continue;
            JAXXObjectActionSupport.makeActionsEnabledOnlyIfMenuItemParentIsOpened((JMenu)component);
        }
        listener.updateElements(false);
    }

    protected abstract InputMap getInputMap(UI var1, int var2);

    protected abstract int getInputMapCondition();

    protected abstract ActionMap getActionMap(UI var1);

    public static <U extends JAXXObject, A extends JAXXObjectActionSupport<U>> void run(U ui, Class<A> actionType) {
        JAXXObjectActionSupport a = (JAXXObjectActionSupport)Objects2.newInstance(actionType);
        JAXXObjectActionSupport.run(ui, a);
    }

    public static <U extends JAXXObject, A extends JAXXObjectActionSupport<U>> void run(U ui, A action) {
        action.setUi(ui);
        ((Runnable)((Object)action)).run();
    }

    public static <U extends JAXXObject, A extends JAXXObjectActionSupport<U>> A init(U ui, AbstractButton editor, A action) {
        log.info(String.format("[%s] init action: %s", ui.getClass().getSimpleName(), action.getName()));
        action.setUi(ui);
        action.setEditor(editor);
        action.init();
        return action;
    }

    public static <U extends JAXXObject, A extends JAXXObjectActionSupport<U>> A init(U ui, AbstractButton editor) {
        Class actionType = (Class)editor.getClientProperty(ACTION_TYPE);
        return actionType == null ? null : (A)JAXXObjectActionSupport.init(ui, editor, actionType);
    }

    public static <U extends JAXXObject, A extends JAXXObjectActionSupport<U>> A init(U ui, AbstractButton editor, Class<A> actionType) {
        JAXXObjectActionSupport action = (JAXXObjectActionSupport)Objects2.newInstance(actionType);
        log.info(String.format("[%s] init action: %s", ui.getClass().getSimpleName(), action.getName()));
        action.setUi(ui);
        action.setEditor(editor);
        action.init();
        return (A)action;
    }

    public void init() {
        AbstractButton editor = this.getEditor();
        if (editor != null) {
            JAXXObjectActionSupport previousAction = (JAXXObjectActionSupport)editor.getClientProperty("$$JaxxAction$$");
            if (previousAction != null) {
                previousAction.removePreviousAction();
            }
            editor.putClientProperty("$$JaxxAction$$", this);
            editor.addPropertyChangeListener(ENABLED, this.onEnabledChanged);
            if (editor instanceof JMenuItem) {
                Icon largeIcon;
                this.setAddKeyStrokeToText(false);
                this.setAddMnemonicAsKeyStroke(false);
                if (this.getMnemonic() != 0) {
                    this.setDisplayMnemonicIndexKey(0);
                    this.setKeyStroke(KeyStroke.getKeyStroke(this.getMnemonic(), 0));
                }
                if (editor instanceof JCheckBoxMenuItem && (largeIcon = this.getLargeIcon()) != null) {
                    editor.setIcon(largeIcon);
                }
            }
        }
        this.defaultInit(this.getInputMap(this.ui, this.getInputMapCondition()), this.getActionMap(this.ui));
    }

    private JAXXObjectActionSupport(String actionCommandKey, String label, String shortDescription, String actionIcon) {
        this.name = actionCommandKey == null ? this.getClass().getName() : actionCommandKey;
        this.text = I18n.t((String)label, (Object[])new Object[0]);
        this.tooltipText = I18n.t((String)shortDescription, (Object[])new Object[0]);
        if (actionIcon != null) {
            this.icon = SwingUtil.getUIManagerActionIcon(actionIcon);
        }
        this.onEnabledChanged = e -> this.setEnabled((Boolean)e.getNewValue());
    }

    protected abstract void doActionPerformed(ActionEvent var1, UI var2);

    @Override
    public final Object getValue(String key) {
        return this.get((String)PROPERTY_MAPPING.getOrDefault((Object)key, (Object)key));
    }

    @Override
    public final void putValue(String key, Object value) {
        this.set((String)PROPERTY_MAPPING.getOrDefault((Object)key, (Object)key), value);
    }

    protected Class getJavaBeanType() {
        return JAXXObjectActionSupport.class;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        boolean oldValue = this.isEnabled();
        this.enabled = enabled;
        log.debug(String.format("Action [%s] - enabled? %s \u2192 %s", this.getActionCommandKey(), oldValue, enabled));
        this.firePropertyChange(ENABLED, oldValue, enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canExecuteAction(e)) {
            this.doActionPerformed(e, this.ui);
        }
    }

    public boolean isCheckMenuItemIsArmed() {
        return this.checkMenuItemIsArmed;
    }

    public void setCheckMenuItemIsArmed(boolean checkMenuItemIsArmed) {
        this.checkMenuItemIsArmed = checkMenuItemIsArmed;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String text) {
        this.text = text;
    }

    public final String getTooltipText() {
        return this.tooltipText;
    }

    public final void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    public final KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public final void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public final int getMnemonic() {
        return this.mnemonic;
    }

    public final void setMnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
    }

    public final Icon getIcon() {
        return this.icon;
    }

    public final void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isSelectedKey() {
        return this.selectedKey;
    }

    public final void setSelectedKey(boolean selectedKey) {
        this.selectedKey = selectedKey;
    }

    public int getDisplayMnemonicIndexKey() {
        return this.displayMnemonicIndexKey;
    }

    public final void setDisplayMnemonicIndexKey(int displayMnemonicIndexKey) {
        this.displayMnemonicIndexKey = displayMnemonicIndexKey;
    }

    public boolean isAddMnemonicAsKeyStroke() {
        return this.addMnemonicAsKeyStroke;
    }

    public void setAddMnemonicAsKeyStroke(boolean addMnemonicAsKeyStroke) {
        this.addMnemonicAsKeyStroke = addMnemonicAsKeyStroke;
    }

    public Icon getLargeIcon() {
        return this.largeIcon;
    }

    public final void setLargeIcon(Icon largeIcon) {
        this.largeIcon = largeIcon;
    }

    public final KeyStroke getAcceleratorKey() {
        return this.keyStroke;
    }

    public final String getActionCommandKey() {
        return this.name;
    }

    public final UI getUi() {
        return this.ui;
    }

    public final void setUi(UI ui) {
        this.ui = ui;
    }

    public final AbstractButton getEditor() {
        return this.editor;
    }

    public void setEditor(AbstractButton editor) {
        this.editor = editor;
    }

    public boolean isAddKeyStrokeToText() {
        return this.addKeyStrokeToText;
    }

    public void setAddKeyStrokeToText(boolean addKeyStrokeToText) {
        this.addKeyStrokeToText = addKeyStrokeToText;
    }

    public final void register(InputMap inputMap, ActionMap actionMap) {
        if (this.keyStroke != null && inputMap != null && actionMap != null) {
            String actionCommandKey = this.getActionCommandKey();
            inputMap.put(this.keyStroke, actionCommandKey);
            actionMap.put(actionCommandKey, this);
        }
    }

    public final void unregister(InputMap inputMap, ActionMap actionMap) {
        if (this.keyStroke != null && inputMap != null && actionMap != null) {
            String actionCommandKey = this.getActionCommandKey();
            inputMap.remove(this.keyStroke);
            actionMap.remove(actionCommandKey);
        }
    }

    public void displayInfo(String title, String text) {
        JOptionPanes.displayInfo((Component)this.ui, title, text);
    }

    public void displayWarning(String title, String text) {
        JOptionPanes.displayWarning((Component)this.ui, title, text);
    }

    public int askUser(String title, String message, int typeMessage, Object[] options, int defaultOption) {
        return JOptionPanes.askUser((Component)this.ui, title, message, typeMessage, options, defaultOption);
    }

    public int askUser(String title, Object message, int typeMessage, Object[] options, int defaultOption) {
        return JOptionPanes.askUser((Component)this.ui, title, message, typeMessage, options, defaultOption);
    }

    public int askUser(JOptionPane pane, String title, Object[] options) {
        return JOptionPanes.askUser((Frame)this.ui, pane, title, options);
    }

    protected boolean canExecuteAction(ActionEvent e) {
        AbstractButton editor = this.getEditor();
        Objects.requireNonNull(editor);
        if (!editor.isVisible()) {
            log.info(String.format("Reject action : %s from editor not visible.", this.getName()));
            return false;
        }
        if (!editor.isEnabled()) {
            log.info(String.format("Reject action : %s from editor not enabled.", this.getName()));
            return false;
        }
        if (editor instanceof JMenuItem && this.isCheckMenuItemIsArmed()) {
            boolean armed = ((JMenuItem)editor).isArmed();
            if (!armed) {
                log.info(String.format("Reject action : %s from editor not armed.", this.getName()));
                return false;
            }
            Boolean activateFromPopup = (Boolean)editor.getClientProperty(ACTIVATE_FROM_POPUP);
            if (activateFromPopup != null && !activateFromPopup.booleanValue()) {
                log.info(String.format("Reject action : %s from editor (popup is not visible).", this.getName()));
                return false;
            }
            return true;
        }
        if (!editor.isShowing()) {
            log.info(String.format("Reject action : %s from editor not showing.", this.getName()));
            return false;
        }
        boolean result = this.canExecutionActionFromLayer(this.getEditor(), e);
        if (result) {
            log.info(String.format("Accept action : %s", this.getName()));
        } else {
            log.info(String.format("Reject action : %s", this.getName()));
        }
        return result;
    }

    protected boolean canExecutionActionFromLayer(Component editor, ActionEvent e) {
        if (editor == null) {
            return true;
        }
        JXLayer ancestor = (JXLayer)SwingUtilities.getAncestorOfClass(JXLayer.class, editor);
        if (ancestor == null) {
            return true;
        }
        LayerUI ui = ancestor.getUI();
        if (ui instanceof BlockingLayerUI && !((BlockingLayerUI)ui).acceptEventOrConsumeIt(e)) {
            log.info(String.format("Reject action %s from blockingUI: %s", this.getName(), ui));
            return false;
        }
        return this.canExecutionActionFromLayer((Component)ancestor, e);
    }

    protected void defaultInit(InputMap inputMap, ActionMap actionMap) {
        if (this.editor != null) {
            KeyStroke keyStroke;
            Icon icon;
            String tip;
            log.debug("init action " + this.getActionCommandKey());
            String text = this.editor.getText();
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                this.setText(text);
            }
            if (StringUtils.isNotEmpty((CharSequence)(tip = this.editor.getToolTipText()))) {
                this.setTooltipText(tip);
            }
            if ((icon = this.editor.getIcon()) != null) {
                this.setIcon(icon);
            }
            if ((keyStroke = (KeyStroke)this.editor.getClientProperty("keyStroke")) != null) {
                this.keyStroke = keyStroke;
            }
            if (this.addMnemonicAsKeyStroke && keyStroke == null && this.mnemonic != 0) {
                this.setKeyStroke(KeyStroke.getKeyStroke(this.mnemonic, 8));
            }
            this.rebuildTexts(false);
            this.setEnabled(this.editor.isEnabled());
            this.editor.setAction(this);
        }
        this.register(inputMap, actionMap);
    }

    public void rebuildTexts(boolean updateAction) {
        if (this.addKeyStrokeToText && this.keyStroke != null) {
            if (updateAction) {
                this.removeKeyStrokeToText();
            }
            this.addKeyStrokeToText(this.getText(), this.getTooltipText());
        }
        if (updateAction) {
            this.editor.setText(this.getText());
            this.editor.setToolTipText(this.getTooltipText());
        }
    }

    protected void removePreviousAction() {
        if (this.editor == null) {
            return;
        }
        InputMap inputMap = this.getInputMap(this.getUi(), this.getInputMapCondition());
        ActionMap actionMap = this.getActionMap(this.getUi());
        this.unregister(inputMap, actionMap);
        this.editor.removePropertyChangeListener(ENABLED, this.onEnabledChanged);
        this.removeKeyStrokeToText();
    }

    private void addKeyStrokeToText(String label, String shortDescription) {
        if (this.keyStroke == null) {
            return;
        }
        String acceleratorStr = SwingUtil.keyStrokeToStr(this.keyStroke);
        this.setText(label == null ? null : I18n.t((String)label, (Object[])new Object[0]) + acceleratorStr);
        this.setTooltipText(shortDescription == null ? null : I18n.t((String)shortDescription, (Object[])new Object[0]) + acceleratorStr);
    }

    private void removeKeyStrokeToText() {
        String toolTipText;
        if (this.keyStroke == null) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        String acceleratorStr = SwingUtil.keyStrokeToStr(this.keyStroke);
        String text = this.editor.getText();
        if (text != null && text.endsWith(acceleratorStr)) {
            this.editor.setText(text.substring(0, text.length() - acceleratorStr.length()).trim());
        }
        if ((toolTipText = this.editor.getToolTipText()) != null && toolTipText.endsWith(acceleratorStr)) {
            this.editor.setToolTipText(toolTipText.substring(0, toolTipText.length() - acceleratorStr.length()).trim());
        }
    }

    static class MakeActionsEnabledOnlyIfMenuItemParentIsOpenedPopupMenuListener
    implements PopupMenuListener {
        private static final Logger log = LogManager.getLogger(MakeActionsEnabledOnlyIfMenuItemParentIsOpenedPopupMenuListener.class);
        private final JMenu jMenu;
        private boolean adjusting;

        public MakeActionsEnabledOnlyIfMenuItemParentIsOpenedPopupMenuListener(JMenu jMenu) {
            this.jMenu = Objects.requireNonNull(jMenu);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.updateElements(true);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(() -> this.updateElements(false));
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.updateElements(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateElements(boolean activateFromPopup) {
            if (this.adjusting) {
                return;
            }
            this.adjusting = true;
            try {
                String state = activateFromPopup ? JAXXObjectActionSupport.ENABLED : "disabled";
                for (Component subElement : this.jMenu.getMenuComponents()) {
                    JMenuItem component;
                    if (!(subElement instanceof JMenuItem) || (component = (JMenuItem)subElement).getAccelerator() == null || !(component.getAction() instanceof JAXXObjectActionSupport)) continue;
                    log.info(String.format("Menu (%s) item (%s) will %s", this.jMenu.getName(), component.getName(), state));
                    component.putClientProperty(JAXXObjectActionSupport.ACTIVATE_FROM_POPUP, activateFromPopup);
                }
            }
            finally {
                this.adjusting = false;
            }
        }
    }
}

