/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.tree;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.TreeNode;
import org.nuiton.jaxx.runtime.swing.tree.IterableTreeNode;

public class DefaultIterableTreeNode<O>
implements IterableTreeNode<O> {
    private static final Enumeration<IterableTreeNode<?>> EMPTY_ENUMERATION = Collections.emptyEnumeration();
    private IterableTreeNode parent;
    private List<IterableTreeNode<?>> children;
    private O userObject;
    private boolean allowsChildren;

    public DefaultIterableTreeNode(O userObject, boolean allowsChildren) {
        this.userObject = userObject;
        this.allowsChildren = allowsChildren;
    }

    @Override
    public IterableTreeNode<?> getChildAt(int childIndex) {
        return this.isEmpty() ? null : this.children.get(childIndex);
    }

    @Override
    public final int getChildCount() {
        return this.isEmpty() ? 0 : this.children.size();
    }

    @Override
    public final boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public IterableTreeNode<?> getRoot() {
        return this.isRoot() ? this : this.getParent().getRoot();
    }

    @Override
    public IterableTreeNode<?> getParent() {
        return this.parent;
    }

    @Override
    public final void setParent(IterableTreeNode<?> parent) {
        this.parent = parent;
    }

    @Override
    public final int getIndex(TreeNode node) {
        Objects.requireNonNull(node);
        if (!(node instanceof DefaultIterableTreeNode)) {
            throw new IllegalArgumentException("node should be a DefaultIterableTreeNode, but was: " + node.getClass().getName());
        }
        return this.isEmpty() ? -1 : this.children.indexOf(node);
    }

    @Override
    public final boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public final void setAllowsChildren(boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
    }

    @Override
    public boolean isLeaf() {
        return this.isEmpty();
    }

    public final Enumeration children() {
        return this.isEmpty() ? EMPTY_ENUMERATION : Collections.enumeration(this.children);
    }

    @Override
    public final Iterator<IterableTreeNode<?>> iterator() {
        return this.isEmpty() ? EMPTY_ITERATOR : this.children.iterator();
    }

    @Override
    public final boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    @Override
    public final O getUserObject() {
        return this.userObject;
    }

    @Override
    public final void setUserObject(O userObject) {
        this.userObject = userObject;
    }

    @Override
    public final void addChild(IterableTreeNode<?> newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insertChild(newChild, this.getChildCount() - 1);
        } else {
            this.insertChild(newChild, this.getChildCount());
        }
    }

    @Override
    public final void insertChild(IterableTreeNode<?> newChild, int position) {
        Objects.requireNonNull(newChild);
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        TreeNode oldParent = newChild.getParent();
        if (oldParent != null) {
            oldParent.removeChild(newChild);
        }
        newChild.setParent(this);
        this.getNotNullChildren().add(position, newChild);
    }

    @Override
    public final void removeChild(IterableTreeNode<?> child) {
        boolean remove = this.getNotNullChildren().remove(Objects.requireNonNull(child));
        if (!remove) {
            throw new IllegalArgumentException("argument is not a child");
        }
        child.setParent(null);
    }

    @Override
    public final void removeChild(int index) {
        TreeNode childAt = this.getChildAt(index);
        this.removeChild((IterableTreeNode<?>)childAt);
    }

    @Override
    public void removeChildren() {
        if (this.isEmpty()) {
            return;
        }
        this.children.forEach(c -> c.setParent(null));
        this.children.clear();
    }

    @Override
    public void removeChildren(List<IterableTreeNode<?>> children) {
        children.forEach(this::removeChild);
    }

    public final boolean isNodeAncestor(IterableTreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        TreeNode ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    private List<IterableTreeNode<?>> getNotNullChildren() {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        return this.children;
    }
}

