/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JTables {
    private static final Log log = LogFactory.getLog(JTables.class);

    public static void selectFirstCellOnFirstRowAndStopEditing(JTable table) {
        JTables.doSelectCell(table, 0, 0);
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public static void selectFirstCellOnLastRow(JTable table) {
        JTables.doSelectCell(table, table.getRowCount() - 1, 0);
    }

    public static void selectFirstCellOnRow(JTable table, int row, boolean stopEdit) {
        JTables.doSelectCell(table, row, 0);
        if (stopEdit && table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public static void doSelectCell(JTable table, int rowIndex, int columnIndex) {
        int rowCount = table.getRowCount();
        if (rowCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No row in table, can not select any cell");
            }
            return;
        }
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No column in table, can not select any cell");
            }
            return;
        }
        if (columnIndex > columnCount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("ColumnIndex: %s is more than columnCount %s", columnIndex, columnCount));
            }
            columnIndex = columnCount - 1;
        }
        if (columnIndex < 0) {
            columnIndex = 0;
        }
        if (rowIndex >= rowCount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("RowIndex: %s is more than rowCount %s", rowIndex, rowCount));
            }
            rowIndex = rowCount - 1;
        }
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        table.setColumnSelectionInterval(columnIndex, columnIndex);
        table.setRowSelectionInterval(rowIndex, rowIndex);
        table.editCellAt(rowIndex, columnIndex);
    }
}

