/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.renderer;

import java.awt.Component;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class LocaleListCellRenderer
extends DefaultListCellRenderer {
    public static final Logger log = LogManager.getLogger(LocaleListCellRenderer.class);
    private static final long serialVersionUID = 1L;
    protected final Map<Locale, Icon> cache = new HashMap<Locale, Icon>();
    protected boolean showIcon;
    protected boolean showText;

    public LocaleListCellRenderer() {
        this(true, true);
    }

    public LocaleListCellRenderer(boolean showIcon, boolean showText) {
        this.showIcon = showIcon;
        this.showText = showText;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Locale locale = (Locale)value;
        if (locale != null) {
            Icon icon = this.getIcon(locale);
            comp.setIcon(icon);
        }
        String text = this.getText(locale);
        String tip = this.getToolTipText(locale);
        comp.setText(text);
        comp.setToolTipText(tip);
        return comp;
    }

    public String getText(Locale locale) {
        String text = null;
        if (this.showText) {
            text = this.getSafeText(locale);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(Locale locale) {
        if (!this.showIcon) {
            return null;
        }
        Map<Locale, Icon> map = this.cache;
        synchronized (map) {
            return this.getSafeIcon(locale);
        }
    }

    public String getToolTipText(Locale locale) {
        return locale.getDisplayName(Locale.getDefault());
    }

    public boolean isShowText() {
        return this.showText;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public void setShowIcon(boolean showIcon) {
        boolean old = this.showIcon;
        this.showIcon = showIcon;
        this.firePropertyChange("showIcon", old, showIcon);
    }

    public void setShowText(boolean showText) {
        boolean old = this.showText;
        this.showText = showText;
        this.firePropertyChange("showText", old, showText);
    }

    public String getSafeText(Locale locale) {
        return locale.getDisplayName(Locale.getDefault());
    }

    public synchronized Icon getSafeIcon(Locale locale) {
        Icon icon = this.cache.get(locale);
        if (icon != null) {
            return icon;
        }
        icon = SwingUtil.getUIManagerActionIcon("i18n-" + locale.toString());
        if (icon == null) {
            log.warn("could not find icon action.i18n-" + locale.toString());
            if (locale.getCountry() != null && (icon = SwingUtil.getUIManagerActionIcon("i18n-" + locale.getCountry().toLowerCase())) == null) {
                log.warn("could not find icon action.i18n-" + locale.getCountry().toLowerCase());
                icon = SwingUtil.createActionIcon("i18n-" + locale.getCountry().toLowerCase());
                if (icon == null) {
                    log.warn("could not find icon action.i18n-" + locale.getCountry().toLowerCase());
                }
            }
        }
        this.cache.put(locale, icon);
        return icon;
    }
}

