/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class JOptionPanes {
    public static void displayInfo(Component ui, String title, String text) {
        JOptionPane.showMessageDialog(ui, text, title, 1);
    }

    public static void displayWarning(Component ui, String title, String text) {
        JOptionPane.showMessageDialog(ui, text, title, 2);
    }

    public static int askUser(Component parent, String title, Object message, int typeMessage, Object[] options, int defaultOption) {
        Objects.requireNonNull(parent);
        return JOptionPane.showOptionDialog(parent, message, title, -1, typeMessage, null, options, options[defaultOption]);
    }

    public static int askUser(Frame ui, final JOptionPane pane, String title, Object[] options) {
        final JDialog dialog = new JDialog(ui, true);
        dialog.setTitle(title);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        dialog.setResizable(false);
        dialog.pack();
        dialog.setLocationRelativeTo(ui);
        final PropertyChangeListener listener = event -> {
            if (dialog.isVisible() && event.getSource() == pane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                dialog.setVisible(false);
            }
        };
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                pane.setValue(null);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                pane.removePropertyChangeListener(listener);
                dialog.getContentPane().removeAll();
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    pane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        pane.addPropertyChangeListener(listener);
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }
}

