/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.awt.visitor;

import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.awt.visitor.ComponentTreeNode;
import org.nuiton.jaxx.runtime.awt.visitor.ComponentTreeNodeVisitor;

public class GetCompopentAtPointVisitor
implements ComponentTreeNodeVisitor {
    private static final Logger log = LogManager.getLogger(GetCompopentAtPointVisitor.class);
    final int currentX;
    final int currentY;
    final List<ComponentTreeNode> components = Lists.newArrayList();

    public static Component get(ComponentTreeNode node, Point p) {
        GetCompopentAtPointVisitor v = new GetCompopentAtPointVisitor(p);
        node.visit(v);
        Component result = v.getLastComponent();
        v.components.clear();
        return result;
    }

    public GetCompopentAtPointVisitor(Point p) {
        this.currentX = (int)p.getX();
        this.currentY = (int)p.getY();
    }

    public Component getLastComponent() {
        Component result = null;
        if (!this.components.isEmpty()) {
            ComponentTreeNode node = this.components.get(this.components.size() - 1);
            result = node.getUserObject();
        }
        return result;
    }

    @Override
    public void startNode(ComponentTreeNode node) {
        Component component = node.getUserObject();
        if (!component.isVisible() || !component.isShowing()) {
            if (log.isDebugEnabled()) {
                log.debug("Skip invisible component: " + component.getClass().getSimpleName() + "::" + component.getName());
            }
            return;
        }
        if (node.isRoot() || this.components.contains(node.getParent())) {
            Point locationOnScreen = component.getLocationOnScreen();
            Rectangle bounds = component.getBounds();
            bounds.setLocation(locationOnScreen);
            boolean containsPoint = bounds.contains(this.currentX, this.currentY);
            if (containsPoint) {
                if (log.isDebugEnabled()) {
                    log.debug("Accept component: " + component);
                }
                this.components.add(node);
            }
        }
    }

    @Override
    public void endNode(ComponentTreeNode componentTree) {
    }
}

