/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.tree;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.nuiton.jaxx.runtime.swing.tree.TreeFilter;

public class FilterTreeModel
implements TreeModel {
    private final TreeModel delegateModel;
    private final Set<TreeModelListener> treeModelListeners;
    private TreeFilter treeFilter;

    public FilterTreeModel(TreeModel delegateModel) {
        this(delegateModel, null);
    }

    public FilterTreeModel(TreeModel delegateModel, TreeFilter filter) {
        Objects.requireNonNull(delegateModel);
        this.delegateModel = delegateModel;
        this.treeFilter = filter;
        this.treeModelListeners = new LinkedHashSet<TreeModelListener>();
        if (delegateModel instanceof DefaultTreeModel) {
            this.treeModelListeners.addAll(Arrays.asList(((DefaultTreeModel)delegateModel).getTreeModelListeners()));
        }
    }

    public void setFilter(TreeFilter treeFilter) {
        this.treeFilter = treeFilter;
        TreePath path = new TreePath(this.delegateModel.getRoot());
        this.fireTreeStructureChanged(path);
    }

    @Override
    public int getChildCount(Object parent) {
        int realCount = this.delegateModel.getChildCount(parent);
        int filterCount = 0;
        for (int i = 0; i < realCount; ++i) {
            Object child = this.delegateModel.getChild(parent, i);
            if (!this.include(child)) continue;
            ++filterCount;
        }
        return filterCount;
    }

    @Override
    public Object getChild(Object parent, int index) {
        int cnt = -1;
        int childCount = this.delegateModel.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.delegateModel.getChild(parent, i);
            if (this.include(child)) {
                ++cnt;
            }
            if (cnt != index) continue;
            return child;
        }
        return null;
    }

    @Override
    public Object getRoot() {
        return this.delegateModel.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.delegateModel.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.delegateModel.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.delegateModel.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
        this.delegateModel.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
        this.delegateModel.removeTreeModelListener(l);
    }

    private void fireTreeStructureChanged(TreePath path) {
        TreeModelEvent e = null;
        for (TreeModelListener current : this.treeModelListeners) {
            if (e == null) {
                e = new TreeModelEvent((Object)this.delegateModel, path);
            }
            current.treeStructureChanged(e);
        }
    }

    private boolean include(Object node) {
        return this.treeFilter == null || this.treeFilter.include(this.delegateModel, node);
    }
}

