/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.Stack;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.tree.TreeNode;

public interface IterableTreeNode<O>
extends TreeNode,
Iterable<IterableTreeNode<?>> {
    public static final Iterator<IterableTreeNode<?>> EMPTY_ITERATOR = Collections.emptyIterator();
    public static final int STREAM_CHARACTERISTICS = 1360;

    public static Stream<IterableTreeNode<?>> stream(Iterator<IterableTreeNode<?>> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1360), false);
    }

    default public Stream<IterableTreeNode<?>> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1360), false);
    }

    public boolean isRoot();

    public IterableTreeNode<?> getRoot();

    @Override
    public IterableTreeNode<?> getParent();

    public void setParent(IterableTreeNode<?> var1);

    public void setAllowsChildren(boolean var1);

    public boolean isEmpty();

    public O getUserObject();

    public void setUserObject(O var1);

    public void addChild(IterableTreeNode<?> var1);

    public void insertChild(IterableTreeNode<?> var1, int var2);

    public void removeChild(int var1);

    public void removeChild(IterableTreeNode<?> var1);

    public void removeChildren();

    public void removeChildren(List<IterableTreeNode<?>> var1);

    default public Iterator<IterableTreeNode<?>> preorderIterator() {
        return this.isEmpty() ? EMPTY_ITERATOR : new PreorderIterator(this);
    }

    default public Iterator<IterableTreeNode<?>> postorderIterator() {
        return this.isEmpty() ? EMPTY_ITERATOR : new PostorderIterator(this);
    }

    default public Iterator<IterableTreeNode<?>> breadthFirstIterator() {
        return this.isEmpty() ? EMPTY_ITERATOR : new BreadthFirstIterator(this);
    }

    public static final class BreadthFirstIterator
    implements Iterator<IterableTreeNode<?>> {
        private final Queue queue;

        public BreadthFirstIterator(IterableTreeNode<?> rootNode) {
            Objects.requireNonNull(rootNode);
            this.queue = new Queue();
            Set<IterableTreeNode<?>> singleton = Collections.singleton(rootNode);
            this.queue.enqueue(singleton.iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty() && this.queue.peek().hasNext();
        }

        @Override
        public IterableTreeNode<?> next() {
            Iterator<IterableTreeNode<?>> currentIterator = this.queue.peek();
            IterableTreeNode<?> node = currentIterator.next();
            if (!currentIterator.hasNext()) {
                this.queue.pop();
            }
            if (!node.isEmpty()) {
                this.queue.enqueue(node.iterator());
            }
            return node;
        }

        public final class Queue {
            QNode head;
            QNode tail;

            public void enqueue(Iterator<IterableTreeNode<?>> anObject) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(anObject, null);
                } else {
                    this.tail = this.tail.next = new QNode(anObject, null);
                }
            }

            public void pop() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                QNode oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
            }

            public Iterator<IterableTreeNode<?>> peek() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Iterator<IterableTreeNode<?>> object;
                public QNode next;

                public QNode(Iterator<IterableTreeNode<?>> object, QNode next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    public static final class PostorderIterator
    implements Iterator<IterableTreeNode<?>> {
        private IterableTreeNode<?> root;
        private Iterator<IterableTreeNode<?>> children;
        private Iterator<IterableTreeNode<?>> subtree;

        public PostorderIterator(IterableTreeNode<?> rootNode) {
            Objects.requireNonNull(rootNode);
            this.root = rootNode;
            this.children = this.root.iterator();
            this.subtree = EMPTY_ITERATOR;
        }

        @Override
        public boolean hasNext() {
            return this.root != null;
        }

        @Override
        public IterableTreeNode<?> next() {
            IterableTreeNode<?> returnValue;
            if (this.subtree.hasNext()) {
                returnValue = this.subtree.next();
            } else if (this.children.hasNext()) {
                this.subtree = new PostorderIterator(this.children.next());
                returnValue = this.subtree.next();
            } else {
                returnValue = this.root;
                this.root = null;
            }
            return returnValue;
        }
    }

    public static final class PreorderIterator
    implements Iterator<IterableTreeNode<?>> {
        private final Stack<Iterator> stack = new Stack();

        public PreorderIterator(IterableTreeNode<?> rootNode) {
            this.stack.push(Collections.singleton(rootNode).iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty() && this.stack.peek().hasNext();
        }

        @Override
        public IterableTreeNode next() {
            Iterator children;
            Iterator currentIterator = this.stack.peek();
            IterableTreeNode node = (IterableTreeNode)currentIterator.next();
            if (!currentIterator.hasNext()) {
                this.stack.pop();
            }
            if ((children = node.iterator()).hasNext()) {
                this.stack.push(children);
            }
            return node;
        }
    }
}

